% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deprecated.R
\name{interpret_bf}
\alias{interpret_bf}
\title{Bayes Factor Interpretation}
\usage{
interpret_bf(x, direction = TRUE, bf = TRUE, rules = "jeffreys1961")
}
\arguments{
\item{x}{Bayes Factor.}

\item{direction}{Include direction (against / in favour).}

\item{bf}{Include Bayes Factor.}

\item{rules}{Can be "jeffreys1961" (default), "raftery1995", or a custom list.}
}
\description{
Return the interpretation of a Bayes Factor.
}
\examples{
library(psycho)
interpret_bf(x = 10)
}
\references{
\itemize{
 \item{Jeffreys, H. (1961), Theory of Probability, 3rd ed., Oxford University Press, Oxford.}
 \item{Jarosz, A. F., & Wiley, J. (2014). What are the odds? A practical guide to computing and reporting Bayes factors. The Journal of Problem Solving, 7(1), 2.}
 }
}
\author{
\href{https://dominiquemakowski.github.io/}{Dominique Makowski}
}
