% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/psychrolib.R
\name{GetMoistAirVolume}
\alias{GetMoistAirVolume}
\title{Return moist air specific volume given dry-bulb temperature, humidity ratio, and pressure.}
\usage{
GetMoistAirVolume(TDryBulb, HumRatio, Pressure)
}
\arguments{
\item{TDryBulb}{A numeric vector of dry-bulb temperature in degreeF [IP] or degreeC [SI]}

\item{HumRatio}{A numeric vector of humidity ratio in lb_H2O lb_Air-1 [IP] or kg_H2O kg_Air-1 [SI]}

\item{Pressure}{A numeric vector of atmospheric pressure in Psi [IP] or Pa [SI]}
}
\value{
A numeric vector of specific volume of moist air in ft3 lb-1 of dry air [IP] or in m3 kg-1 of dry air [SI]
}
\description{
Return moist air specific volume given dry-bulb temperature, humidity ratio, and pressure.
}
\note{
In IP units, R_DA_IP / 144 equals 0.370486 which is the coefficient appearing in eqn 26.

The factor 144 is for the conversion of Psi = lb in-2 to lb ft-2.
}
\examples{
SetUnitSystem("IP")
GetMoistAirVolume(80:100, 0.02, 14.175)

SetUnitSystem("SI")
GetMoistAirVolume(20:30, 0.02, 95461)

}
\references{
ASHRAE Handbook - Fundamentals (2017) ch. 1 eqn 26
}
