% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization-utils.R
\name{scatterplot}
\alias{scatterplot}
\title{A two dimensional scatterplot}
\usage{
scatterplot(
  x,
  y,
  data,
  by = NULL,
  best_fit_line = FALSE,
  xlab = NULL,
  ylab = NULL
)
}
\arguments{
\item{x}{A numeric variable in \code{data}. Its values are plotted on the x axis.}

\item{y}{A numeric variable in \code{data}. Its values are plotted on the y axis.}

\item{data}{A data frame with the \code{x} and \code{y} variables.}

\item{by}{An optional variable, usually categorical (factor or
character), by which the points in the scatterplot are byed and
coloured.}

\item{best_fit_line}{A logical variable indicating if the line of best fit
should shown or not.}

\item{xlab}{The label of the x-axis (defaults to the \code{x} variable name).}

\item{ylab}{The label of the y-axis (defaults to the \code{y} variable name).}
}
\value{
A \code{ggplot2::ggplot} object, which may be modified with further \code{ggplot2}
commands.
}
\description{
This function is a wrapper around the typical \code{ggplot} command to create two
dimensional scatterplots, i.e. using \code{geom_point}. It provides the option of
colouring point by a third variable, one that is usually, though not
necessarily categorical. Also, it provides the option of placing the line of
best fit on the scatterplot. If points are coloured by a categorical
variable, the a different line of best for each value of the categorical
variable is provided.
}
\examples{
scatterplot(x = attractive, y = trustworthy, data = faithfulfaces)
scatterplot(x = attractive, y = trustworthy, data = faithfulfaces,
            xlab = 'attractiveness', ylab = 'trustworthiness')
scatterplot(x = attractive, y = trustworthy, data = faithfulfaces,
            by = face_sex)
scatterplot(x = trustworthy, y = faithful, data = faithfulfaces,
            by = face_sex, best_fit_line = TRUE)
}
