% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simLaplace.R
\name{simLaplace}
\alias{simLaplace}
\title{Simulate series with the Laplace distribution}
\usage{
simLaplace(n)
}
\arguments{
\item{n}{Length of series.}
}
\value{
vector of length n, simulated harmonic series.
}
\description{
A Laplace (double exponential) series with mean zero and variance 1 is simulated.
}
\details{
The model equation is: 
\deqn{e=(-1)^(u1\ge0.5) * ln(u2) / sqrt(2)}
where u1 and u2 are independent uniform (0,1) random variables.
}
\author{
Yuanhao Lai
}
\keyword{internal}

