% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aa.R
\name{aa.at}
\alias{aa.at}
\title{Residue Found at the Requested Position}
\usage{
aa.at(at, target, uniprot = TRUE)
}
\arguments{
\item{at}{the position in the primary structure of the protein.}

\item{target}{a character string specifying the UniProt ID of the protein of interest or, alternatively, the sequence of that protein.}

\item{uniprot}{logical, if TRUE the argument 'target' should be an ID.}
}
\value{
Returns a single character representing the residue found at the indicated position in the indicated protein.
}
\description{
Returns the residue found at the requested position.
}
\details{
Please, note that when uniprot is set to FALSE, target can be the string returned by a suitable function, such as get.seq or other.
}
\examples{
aa.at(28, 'P01009')
aa.at(at = 80, target = get.seq('P00004', 'metosite'), uniprot = FALSE)
}
\seealso{
is.at(), renum.pdb(), renum.meto(), renum(), aa.comp()
}
\author{
Juan Carlos Aledo
}
