% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metosite.R
\name{meto.search}
\alias{meto.search}
\title{Search for Specific MetO Sites}
\usage{
meto.search(highthroughput.group = TRUE,
                   bodyguard.group = TRUE,
                   regulatory.group = TRUE,
                   gain.activity = 2, loss.activity = 2, gain.ppi = 2,
                   loss.ppi = 2, change.stability = 2, change.location = 2,
                   organism = -1, oxidant = -1)
}
\arguments{
\item{highthroughput.group}{logical, when FALSE the sites described in a high-throughput study (unknown effect) are filtered out.}

\item{bodyguard.group}{logical, when FALSE the sites postulated to function as ROS sink (because when oxidized no apparent effect can be detected) are filtered out.}

\item{regulatory.group}{logical, when FALSE the sites whose oxidation affect the properties of the protein (and therefore may be involved in regulation) are filtered out.}

\item{gain.activity}{introduce 1 or 0 to indicate whether the oxidation of the selected sites implies a gain of activity or not, respectively. If we do not wish to use this property to filter, introduce 2.}

\item{loss.activity}{introduce 1 or 0 to indicate whether or not the oxidation of the selected sites implies a loss of activity or not, respectively. If we do not wish to use this property to filter, introduce 2.}

\item{gain.ppi}{introduce 1 or 0 to indicate whether the oxidation of the selected sites implies a gain of protein-protein interaction or not, respectively. If we do not wish to use this property to filter, introduce 2.}

\item{loss.ppi}{introduce 1 or 0 to indicate whether or not the oxidation of the selected sites implies a loss of protein-protein interaction or not, respectively. If we do not wish to use this property to filter, introduce 2.}

\item{change.stability}{introduce 1 or 0 to indicate whether the oxidation of the selected sites leads to a change in the protein stability or not, respectively. If we do not wish to use this property to filter, introduce 2.}

\item{change.location}{introduce 1 or 0 to indicate whether or not the oxidation of the selected sites implies a change of localization or not, respectively. If we do not wish to use this property to filter, introduce 2.}

\item{organism}{a character string indicating the scientific name of the species of interest, or -1 if we do not wish to filter by species.}

\item{oxidant}{a character string indicating the oxidant, or -1 if we do not wish to filter by oxidants.}
}
\value{
This function returns a dataframe with a line per MetO site.
}
\description{
Searches for specific MetO sites filtering MetOSite according to the selected criteria.
}
\details{
Note that all the arguments of this function are optional. We only pass an argument to the function when we want to use that parameter to filter. Thus, meto.search() will return all the MetO sites found in the database MetOSite.
}
\examples{
meto.search(organism = 'Homo sapiens', oxidant = 'HClO')
\dontrun{meto.search(highthroughput.group = FALSE, bodyguard.group = FALSE, gain.activity = 1)}
}
\references{
Valverde et al. 2019. Bioinformatics 35:4849-4850 (PMID: 31197322)
}
\seealso{
meto.scan(), meto.list()
}
\author{
Juan Carlos Aledo
}
