% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accdpx.R
\name{stru.part}
\alias{stru.part}
\title{Partition of Structural Regions}
\usage{
stru.part(pdb, cutoff = 0.25)
}
\arguments{
\item{pdb}{is either a PDB id, or the path to a pdb file}

\item{cutoff}{accessibility below which a residue is considered to be buried.}
}
\value{
A dataframe where each residue is assigned to one of the four structural groups considered.
}
\description{
Carries out a partition of the structural regions of a given protein.
}
\details{
The accessibilities of a residue computed in the complex (ACCc) and in the monomer (ACCm) allow to distinguish four structural regions as follows.

Interior: ACCc < cutoff & (ACCm - ACCc) = 0.

Surface: ACCc > cutoff &  (ACCm - ACCc) = 0.

Support: ACCm < cutoff & (ACCm - ACCc) > 0.

Rim: ACCc > cutoff & (ACCm - ACCc) > 0.

Core: ACCm > cutoff & ACCc < cutoff.
}
\examples{
\dontrun{stru.part('1u8f')}
}
\references{
Levy (2010) J. Mol. Biol. 403: 660-670 (PMID: 20868694).
}
\seealso{
atom.dpx(), res.dpx(), acc.dssp()
}
\author{
Juan Carlos Aledo
}
