% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{alpha_geometric_percentile}
\alias{alpha_geometric_percentile}
\title{Estimating the Shape Parameter by Geometric Method of Percentiles}
\usage{
alpha_geometric_percentile(dat)
}
\arguments{
\item{dat}{vector of observations}
}
\value{
A list of the following form:
\describe{
  \item{shape}{Estimate of the shape parameter of the data}
  \item{scale}{Estimate of the scale parameter of the data (which is taken
  to be the minimum of the data)}
}
}
\description{
This function uses the Geometric Method of Percentiles to estimate the
\code{shape} parameter of a given set of data. (Bhatti et al. 2018)
}
\examples{
x <- generate_pareto(10000, 5, 2)
alpha_geometric_percentile(x)

}
\references{
Bhatti SH, Hussain S, Ahmad T, Aslam M, Aftab M, Raza MA (2018). "Efficient
estimation of Pareto model: Some modified percentile estimators." 
PLoS ONE, 13(5), 1-15.
}
