% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/routes.R
\name{route_information}
\alias{route_information}
\title{Information for a given route}
\usage{
route_information(
  route_id,
  user_id = determine_user_id(),
  api_key = determine_api_key()
)
}
\arguments{
\item{route_id}{Integer. These can be listed and described with the \code{routes}
function.}

\item{user_id}{Integer or character. A user ID or devid provided by Public
Transport Victoria. Refer to \code{?ptvapi} for more details.}

\item{api_key}{Character. An API key, with dashes, provided by Public
Transport Victoria. Refer to \code{?ptvapi} for more details.}
}
\value{
A tibble of routes, with the following columns:
\itemize{
\item route_id
\item route_gtfs_id
\item route_name
\item route_type
\item route_number
\item service_status
\item service_status_timestamp
}
}
\description{
Information for a given route
}
\examples{
\dontrun{
route_information(6)
}

}
