% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_functions.R
\name{rvf_plot}
\alias{rvf_plot}
\title{Residual vs Fitted plot.}
\usage{
rvf_plot(model, pch = 20, col = 1, aspect = 3/4, ...)
}
\arguments{
\item{model}{A \link{glm} or \link{lm} object with a numerical outcome.}

\item{pch}{Point character passed to \link{xyplot}.}

\item{col}{Colour passed to \link{xyplot}.}

\item{aspect}{Physical aspect ratio passed to \link{xyplot}.}

\item{...}{Further arguments passed to \link{xyplot}.}
}
\description{
\code{rvf_plot} plots studentized residuals against fitted values from \link{glm} objects using package \code{lattice}.
}
\examples{
data(thuesen, package = "ISwR")
model <- lm(short.velocity ~ blood.glucose, data = thuesen)
plot(model, which = 1)
rvf_plot(model)
}
\author{
Josie Athens, Department of Preventive and Social Medicine, University of Otago, New Zealand.

Deepayan Sarkar, R-Core.
}
