% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/display_functions.R
\name{get_r2}
\alias{get_r2}
\title{Estimate R2 or Pseudo-R2 from regression models}
\usage{
get_r2(model, ...)
}
\arguments{
\item{model}{A statistical regression model.}

\item{...}{Additional arguments passed to \code{r2}.}
}
\description{
\code{get_r2} is a is a wrap function that calls \code{r2} from package \code{performance}.
Calculates the R2 or pseudo-R2 value for different regression model objects, returning a character object for easy printing in tables of coefficients.
}
\details{
The main purpose of \code{get_r2} is to allow easy printing of R2 value in tables of coefficients (see examples).
}
\examples{
require(dplyr, quietly = TRUE)
require(sjlabelled, quietly = TRUE)
require(huxtable, quietly = TRUE)

data(birthwt, package = "MASS")
birthwt <- birthwt \%>\%
  mutate(
    smoke = factor(smoke, labels = c("Non-smoker", "Smoker")),
    race = factor(race, labels = c("White", "African American", "Other"))
  ) \%>\%
  var_labels(
    bwt = 'Birth weight (g)',
    smoke = 'Smoking status',
    race = 'Race'
  )

model_norm <- lm(bwt ~ smoke + race, data = birthwt)

model_norm \%>\%
  glm_coef(labels = model_labels(model_norm)) \%>\%
  as_hux() \%>\% set_align(everywhere, 2:3, "right") \%>\%
  theme_pubh(1) \%>\%
  add_footnote(get_r2(model_norm), font_size = 9)
}
\seealso{
\code{\link[performance]{r2}}.
}
