% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_functions.R
\name{axis_labs}
\alias{axis_labs}
\title{Apply labels from variables to axis-labels in plots.}
\usage{
axis_labs(object)
}
\arguments{
\item{object}{ggplot2 object (see examples).}
}
\value{
A ggplot2 object.
}
\description{
\code{axis_labs} takes labels from labelled data to use them as axis-labels for plots generated by \code{gformula} or \code{ggplot2}.
}
\details{
This functions is helpful when data has been already labelled by \code{sjlabelled}. It retrives variable labels and use them for plotting.
}
\examples{
data(kfm, package = "ISwR")
require(sjlabelled, quietly = TRUE)
kfm = kfm \%>\%
  var_labels(
     dl.milk = 'Breast-milk intake (dl/day)',
     sex = 'Sex',
     weight = 'Child weight (kg)',
     ml.suppl = 'Milk substitute (ml/day)',
     mat.weight = 'Maternal weight (kg)',
     mat.height = 'Maternal height (cm)'
     )

kfm \%>\%
  gf_point(weight ~ dl.milk) \%>\%
  gf_lm(col = 2, interval = "confidence", col = 2) \%>\%
  axis_labs()

kfm \%>\%
  box_plot(dl.milk ~ sex, fill='thistle', alpha = 0.8) \%>\%
  axis_labs() \%>\%
  gf_star(x1 = 1, y1 = 10.9, x2 = 2, y2 = 11, y3 = 11.2)
}
