% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pmApi2df.R
\name{pmApi2df}
\alias{pmApi2df}
\title{Convert xml PubMed bibliographic data into a dataframe}
\usage{
pmApi2df(P, format = "bibliometrix")
}
\arguments{
\item{P}{is a list following the xml PubMed structure, downloaded using the function \code{pmApiRequest}.}

\item{format}{is a character. If \code{format = "bibliometrix"} data will be converted in the bibliometrix complatible data format.
If \code{format = "raw"} data will save in a data frame without any other data editing procedure.}
}
\value{
a dataframe containing bibliographic records.

To obtain a free access to NCBI API, please visit: \href{https://www.ncbi.nlm.nih.gov/pmc/tools/developers/}{https://www.ncbi.nlm.nih.gov/pmc/tools/developers/}

To obtain more information about how to write a NCBI search query, please visit: \href{https://pubmed.ncbi.nlm.nih.gov/help/#search-tags}{https://pubmed.ncbi.nlm.nih.gov/help/#search-tags}
}
\description{
It converts PubMed data, downloaded using Entrez API, into a dataframe
}
\examples{

# Example: Querying a collection of publications

\donttest{
query <- "bibliometric*[Title/Abstract] AND english[LA]
         AND Journal Article[PT] AND 2000:2020[DP]"
D <- pmApiRequest(query = query, limit = 100, api_key = NULL)
M <- pmApi2df(D)
}

}
\seealso{
\code{\link{pmApiRequest}}

\code{\link{pmQueryTotalCount}}
}
