% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/io.R
\name{pprint}
\alias{pprint}
\title{Prints an object in a publishable manner}
\usage{
pprint(x, format, ..., concat = TRUE, mmode = pp_opts$get("mmode"),
  separator = pp_opts$get("separator"))
}
\arguments{
\item{x}{object which output should be printed. Can be a list to deliver
additional information to internal functions.}

\item{format}{optional format specifier. Character vector, see details.}

\item{...}{optional arguments passed to internal style functions. See their
help files for more information.}

\item{concat}{logical, whether returned result is in a single character or
a character vector with parts of the statistical output.}

\item{mmode}{logical indicating if the returned result should be set in
math mode (depends on output format).}

\item{separator}{character string specifying the surrounding characters.}
}
\value{
Simply the unmodified object \code{x} in a list if \code{format} is
\code{"object"}, else a character vector.
}
\description{
\code{pprint} formats the output of the given object in a specified way
}
\details{
This function calls internal style functions (depending on specified output
format) to convert the output of the object into the specified publication
style. It offers options to put a math mode and surrounding characters
around the (concatenated) output.

If argument \code{format} is missing, a function tries to determine a
default format specifier. Can be specified to simple return the input
object (\code{"object"}). It is possible to set it to any internal style
function, the selected style supports.
}
\examples{
pprint(t.test(1:30))
pprint(t.test(1:30, 2:31))
pprint(t.test(1:30, 2:31), format = "object")
pprint(t.test(1:30, 2:31), mmode = FALSE, separator = NULL)
pprint(list(t.test(1:30), .843))

}
\seealso{
See \code{\link{pp_opts_style}} for setting publication style and
\code{\link{pp_opts_out}} for setting output format.
}

