% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/batchPulsarSelect.R
\name{getTempDir}
\alias{getTempDir}
\title{Generate a string for a temporary directory}
\usage{
getTempDir(base = tempdir(), len = 6, fsep = .Platform$file.sep)
}
\arguments{
\item{base}{the base path for the temporary directory.}

\item{len}{the number of letters to randomly generate the directory name}

\item{fsep}{the path separator to use (platform dependent)}
}
\value{
a character vector representing a file path for a randomly generated directory.
}
\description{
Generate a string to create a random temporary directory, in a platform indepdendent manner. By default, this directory will live under the subdirectory of the per-session temporary directory given by \code{tempdir} from base R.
}
\details{
This function creates a random path intended for temporary directories. E.g. for testing pulsar's batch mode. This function is useful if you need a safe place to store (and delete) files without endangering important directories or R's per session tmp directory, given by \code{tempdir}, which may be needed for other uses.
}
\seealso{
batch.pulsar
}

