% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Nancestors.R
\name{pop_Nancestors}
\alias{pop_Nancestors}
\alias{pop_Nf}
\alias{pop_Nfe}
\alias{pop_Na}
\alias{pop_Nae}
\alias{pop_Ng}
\title{Population founders and ancestors}
\usage{
pop_Nancestors(ped, reference, nboot = 10000L, seed = NULL, skip_Ng = FALSE)
}
\arguments{
\item{ped}{A dataframe containing the pedigree. Individual (id), maternal (dam), and paternal (sire) identities are mandatory columns.}

\item{reference}{A string naming a column indicating whether individuals belong to the reference population or not. Column must be boolean or coercible to boolean type.}

\item{nboot}{Number of bootstrap iterations (for computing \emph{Ng}).}

\item{seed}{Sets a seed for the random number generator.}

\item{skip_Ng}{Skip \emph{Ng} computation or not (FALSE by default).}
}
\value{
A dataframe containing population size estimates for founders and ancestors:
\itemize{
  \item{\emph{Nr} - } Total number of individuals in the RP
  \item{\emph{Nf} - } Total number of founders
  \item{\emph{Nfe} - } Effective number of founders
  \item{\emph{Na} - } Total number of ancestors
  \item{\emph{Nae} - } Effective number of ancestors
  \item{\emph{Ng} - } Number of founder genome equivalents
  \item{\emph{se_Ng} - } Standard error of Ng
}
If some of the auxiliary functions is used (e.g. \emph{pop_Nr}), only the corresponding numerical estimate will be returned.
In the case of \emph{pop_Ng}, a list object is returned, with the number of founder genome equivalents (Ng) and its standard error (se_Ng).
}
\description{
Estimate the total and effective number of founders and ancestors
in a pedigree, as well as the number of founder genome equivalents
(see details on these parameters below).
Note that a reference population (RP) must be defined, so that founders
and ancestors are referred to the set of individuals belonging to
that RP. This is set by means of a boolean vector passed as argument.
}
\details{
The total number of founders (\emph{Nf}) and ancestors (\emph{Na})
are calculated simply as the count of founders and ancestors of
individuals belonging to the reference population (RP).
Founders here are defined as individuals with both parentals unknown.

The effective number of founders (\emph{Nfe}) is the number of equally
contributing founders, that would account for observed genetic diversity
in the RP, while the effective number of ancestors (\emph{Nae})
is defined as the minimum number of ancestors, founders or not, required
to account for the genetic diversity observed in the RP.
These parameters are computed from the probability of gene origin,
following methods in Tahmoorespur and Sheikhloo (2011).

While the previous parameters account for diversity loss due to bottlenecks
at the level of founders or ancestors, other sources of random loss of
alleles (such as drift) can be accounted by means of the number of
founder genome equivalents (\emph{Ng}, Caballero and Toro 2000).
This parameter is estimated via Monte Carlo simulation of allele segregation,
following Boichard et al. (1997).
}
\examples{
data(arrui)
pop_Nancestors(arrui, reference = "target", skip_Ng = TRUE)
}
\references{
\itemize{
  \item{Boichard D, Maignel L, Verrier E. 1997. The value of using probabilities of gene origin to measure genetic variability in a population. Genet. Sel. Evol. 29: 5-23.}
  \item{Caballero A, Toro M. 2000. Interrelations between effective population size and other pedigree tools for the management of conserved populations. Genet. Res. 75: 331-343.}
  \item{Tahmoorespur M, Sheikhloo M. 2011. Pedigree analysis of the closed nucleus of Iranian Baluchi sheep. Small Rumin. Res. 99: 1-6.}
}
}
