% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/find-position.R
\name{detect}
\alias{detect}
\alias{detect_index}
\title{Find the value or position of the first match.}
\usage{
detect(.x, .p, ..., .right = FALSE)

detect_index(.x, .p, ..., .right = FALSE)
}
\arguments{
\item{.x}{A list or vector.}

\item{.p}{A single predicate function, a formula describing such a
predicate function, or a logical vector of the same length as \code{.x}.
Alternatively, if the elements of \code{.x} are themselves lists of
objects, a string indicating the name of a logical element in the
inner lists. Only those elements where \code{.p} evaluates to
\code{TRUE} will be modified.}

\item{...}{Additional arguments passed on to \code{.f}.}

\item{.right}{If \code{FALSE}, the default, starts at the beginnging
of the vector and move towards the end; if \code{TRUE}, starts at the end
of the vector and moves towards the beginning.}
}
\value{
\code{detect} the value of the first item that matches the
 predicate; \code{detect_index} the position of the matching item.
 If not found, \code{detect} returns \code{NULL} and \code{detect_index}
 returns 0.
}
\description{
Find the value or position of the first match.
}
\examples{
is_even <- function(x) x \%\% 2 == 0

3:10 \%>\% detect(is_even)
3:10 \%>\% detect_index(is_even)

3:10 \%>\% detect(is_even, .right = TRUE)
3:10 \%>\% detect_index(is_even, .right = TRUE)
}

