% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/win2F.R
\name{win2F}
\alias{win2F}
\title{Compute power for a Two Factor Within Subjects ANOVA with up to two by four levels.
Takes means, sds, and sample sizes for each group. Alpha is .05 by default, alternative values may be entered by user}
\usage{
win2F(m1.1, m2.1, m3.1 = NA, m4.1 = NA, m1.2, m2.2, m3.2 = NA,
  m4.2 = NA, s1.1 = NA, s2.1 = NA, s3.1 = NA, s4.1 = NA,
  s1.2 = NA, s2.2 = NA, s3.2 = NA, s4.2 = NA, r12 = NULL,
  r13 = NULL, r14 = NULL, r15 = NULL, r16 = NULL, r17 = NULL,
  r18 = NULL, r23 = NULL, r24 = NULL, r25 = NULL, r26 = NULL,
  r27 = NULL, r28 = NULL, r34 = NULL, r35 = NULL, r36 = NULL,
  r37 = NULL, r38 = NULL, r45 = NULL, r46 = NULL, r47 = NULL,
  r48 = NULL, r56 = NULL, r57 = NULL, r58 = NULL, r67 = NULL,
  r68 = NULL, r78 = NULL, r = NULL, s = NULL, n, alpha = 0.05)
}
\arguments{
\item{m1.1}{Mean of first level factor 1, 1st level factor two}

\item{m2.1}{Mean of second level factor 1, 1st level factor two}

\item{m3.1}{Mean of third level factor 1, 1st level factor two}

\item{m4.1}{Mean of fourth level factor 1, 1st level factor two}

\item{m1.2}{Mean of first level factor 1, 2nd level factor two}

\item{m2.2}{Mean of second level factor 1, 2nd level factor two}

\item{m3.2}{Mean of third level factor 1, 2nd level factor two}

\item{m4.2}{Mean of fourth level factor 1, 2nd level factor two}

\item{s1.1}{Standard deviation of first level factor 1, 1st level factor two}

\item{s2.1}{Standard deviation of second level factor 1, 1st level factor two}

\item{s3.1}{Standard deviation of third level factor 1, 1st level factor two}

\item{s4.1}{Standard deviation of forth level factor 1, 1st level factor two}

\item{s1.2}{Standard deviation of first level factor 1, 2nd level factor two}

\item{s2.2}{Standard deviation of second level factor 1, 2nd level factor two}

\item{s3.2}{Standard deviation of third level factor 1, 2nd level factor two}

\item{s4.2}{Standard deviation of forth level factor 1, 2nd level factor two}

\item{r12}{correlation Factor 1, Level 1 and Factor 1, Level 2}

\item{r13}{correlation Factor 1, Level 1 and Factor 1, Level 3}

\item{r14}{correlation Factor 1, Level 1 and Factor 1, Level 4}

\item{r15}{correlation Factor 1, Level 1 and Factor 2, Level 1}

\item{r16}{correlation Factor 1, Level 1 and Factor 2, Level 2}

\item{r17}{correlation Factor 1, Level 1 and Factor 2, Level 3}

\item{r18}{correlation Factor 1, Level 1 and Factor 2, Level 4}

\item{r23}{correlation Factor 1, Level 2 and Factor 1, Level 3}

\item{r24}{correlation Factor 1, Level 2 and Factor 1, Level 4}

\item{r25}{correlation Factor 1, Level 2 and Factor 2, Level 1}

\item{r26}{correlation Factor 1, Level 2 and Factor 2, Level 2}

\item{r27}{correlation Factor 1, Level 2 and Factor 2, Level 3}

\item{r28}{correlation Factor 1, Level 2 and Factor 2, Level 4}

\item{r34}{correlation Factor 1, Level 3 and Factor 1, Level 4}

\item{r35}{correlation Factor 1, Level 3 and Factor 2, Level 1}

\item{r36}{correlation Factor 1, Level 3 and Factor 2, Level 2}

\item{r37}{correlation Factor 1, Level 3 and Factor 2, Level 3}

\item{r38}{correlation Factor 1, Level 3 and Factor 2, Level 4}

\item{r45}{correlation Factor 1, Level 4 and Factor 2, Level 1}

\item{r46}{correlation Factor 1, Level 4 and Factor 2, Level 2}

\item{r47}{correlation Factor 1, Level 4 and Factor 2, Level 3}

\item{r48}{correlation Factor 1, Level 4 and Factor 2, Level 4}

\item{r56}{correlation Factor 2, Level 1 and Factor 2, Level 2}

\item{r57}{correlation Factor 2, Level 1 and Factor 2, Level 3}

\item{r58}{correlation Factor 2, Level 1 and Factor 2, Level 4}

\item{r67}{correlation Factor 2, Level 2 and Factor 2, Level 3}

\item{r68}{correlation Factor 2, Level 2 and Factor 2, Level 4}

\item{r78}{correlation Factor 2, Level 3 and Factor 2, Level 4}

\item{r}{sets same correlations between DVs on all factor levels (seriously, just use this)}

\item{s}{sets same standard deviation for factor levels (see comment above)}

\item{n}{Sample size for first group}

\item{alpha}{Type I error (default is .05)}
}
\value{
Power for the Two Factor Within Subjects ANOVA
}
\description{
Compute power for a Two Factor Within Subjects ANOVA with up to two by four levels.
Takes means, sds, and sample sizes for each group. Alpha is .05 by default, alternative values may be entered by user
}
\examples{
win2F(m1.1=-.25,m2.1=0,m3.1=.10,m4.1=.15,m1.2=-.25,m2.2=.10,m3.2=.30,m4.2=.35,
s1.1=.4,s2.1=.5,s3.1=2.5,s4.1=2.0,s1.2=.4,s2.2=.5,s3.2=2.5,s4.2=2.0,r=.5,n=80)
win2F(m1.1=-.25,m2.1=0,m1.2=-.25,m2.2=.10,s1.1=.4,s2.1=.5,,s1.2=.4,s2.2=.5,
r12=.5,r13=.4,r14=.55,r23=.4,r24=.5,r34=.45,n=200)
}
