% Generated by roxygen2 (4.0.1): do not edit by hand
\name{create_batch_list}
\alias{create_batch_list}
\title{The function takes an url and a dims object and calculates if this needs to
be downloaded in batches due to download limit restrictions in the pxweb api.
If '*' is used it will get the numberof values for this dimension using a
get_pxweb_metadata call.}
\usage{
create_batch_list(url, dims)
}
\arguments{
\item{url}{The url to download from.}

\item{dims}{The dimension object to use for downloading}
}
\description{
The function takes an url and a dims object and calculates if this needs to
be downloaded in batches due to download limit restrictions in the pxweb api.
If '*' is used it will get the numberof values for this dimension using a
get_pxweb_metadata call.
}
\examples{
url <- "http://api.scb.se/OV0104/v1/doris/sv/ssd/BE/BE0101/BE0101A/BefolkningNy"
dims <- list(Region = c('*'), Civilstand = c('*'), Alder = '1', Kon = c('*'),
            ContentsCode = c('*'), Tid = c('*'))
\donttest{
batches <- create_batch_list(url, dims)
}

url <- "http://api.scb.se/OV0104/v1/doris/sv/ssd/PR/PR0101/PR0101E/Basbeloppet"
dims <- list(ContentsCode = c('*'),
            Tid = c('*'))
\donttest{
batches <- create_batch_list(url, dims)
}
}

