% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/python-install.R
\name{install_pyspark}
\alias{install_pyspark}
\alias{install_databricks}
\title{Installs PySpark and Python dependencies}
\usage{
install_pyspark(
  version = NULL,
  envname = NULL,
  python_version = NULL,
  new_env = TRUE,
  method = c("auto", "virtualenv", "conda"),
  as_job = TRUE,
  install_ml = FALSE,
  ...
)

install_databricks(
  version = NULL,
  cluster_id = NULL,
  envname = NULL,
  python_version = NULL,
  new_env = TRUE,
  method = c("auto", "virtualenv", "conda"),
  as_job = TRUE,
  install_ml = FALSE,
  ...
)
}
\arguments{
\item{version}{Version of 'databricks.connect' to install. Defaults to \code{NULL}.
If \code{NULL}, it will check against PyPi to get the current library version.}

\item{envname}{The name of the Python Environment to use to install the
Python libraries. Defaults to \code{NULL.} If \code{NULL}, a name will automatically
be assigned based on the version that will be installed}

\item{python_version}{The minimum required version of Python to use to create
the Python environment. Defaults to \code{NULL}. If \code{NULL}, it will check against
PyPi to get the minimum required Python version.}

\item{new_env}{If \code{TRUE}, any existing Python virtual environment and/or
Conda environment specified by \code{envname} is deleted first.}

\item{method}{The installation method to use. If creating a new environment,
\code{"auto"} (the default) is equivalent to \code{"virtualenv"}. Otherwise \code{"auto"}
infers the installation method based on the type of Python environment
specified by \code{envname}.}

\item{as_job}{Runs the installation if using this function within the
RStudio IDE.}

\item{install_ml}{Installs ML related Python libraries. Defaults to TRUE. This
is mainly for machines with limited storage to avoid installing the rather
large 'torch' library if the ML features are not going to be used. This will
apply to any environment backed by 'Spark' version 3.5 or above.}

\item{...}{Passed on to \code{\link[reticulate:py_install]{reticulate::py_install()}}}

\item{cluster_id}{Target of the cluster ID that will be used with.
If provided, this value will be used to extract the cluster's
version}
}
\value{
It returns no value to the R session. This function purpose is to
create the 'Python' environment, and install the appropriate set of 'Python'
libraries inside the new environment. During runtime, this function will send
messages to the console describing the steps that the function is
taking. For example, it will let the user know if it is getting the latest
version of the Python library from 'PyPi.org', and the result of such
query.
}
\description{
Installs PySpark and Python dependencies

Installs Databricks Connect and Python dependencies
}
