/*
 * Decompiled with CFR 0.152.
 */
package eu.kliegr.ac1.data;

import eu.kliegr.ac1.data.Attribute;
import eu.kliegr.ac1.data.AttributeType;
import eu.kliegr.ac1.data.AttributeValueType;
import eu.kliegr.ac1.data.Transaction;
import eu.kliegr.ac1.rule.parsers.ArulesParser;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class AttributeValue {
    String value;
    Set<Transaction> transactions = Collections.newSetFromMap(new ConcurrentHashMap());
    Attribute attribute;
    private AttributeValueType type;

    AttributeValue(String value, Attribute attribute, AttributeValueType type) {
        this.type = type;
        this.value = value;
        this.attribute = attribute;
    }

    public String getValue() {
        return this.value;
    }

    public String toString(boolean withAttributeName, boolean valueOrigin) {
        String attName = "";
        String origin = "";
        String _value = this.value;
        if (this.attribute.getType() == AttributeType.numerical) {
            _value = this.value.replace("Infinity", "Inf");
        }
        if (withAttributeName) {
            attName = this.attribute.getName() + "=";
        }
        if (valueOrigin && this.type != AttributeValueType.dataBacked) {
            origin = " (" + this.type.toString() + ")";
        }
        return attName + _value + origin;
    }

    public String toString() {
        return this.toString(false, false);
    }

    public Float getNumericalValue() {
        if (this.value.isEmpty() | this.value == null) {
            return Float.valueOf(Float.NaN);
        }
        return Float.valueOf(Float.parseFloat(ArulesParser.normInfinity(this.value)));
    }

    public AttributeValueType getType() {
        return this.type;
    }

    public void updateType(AttributeValueType type) {
        if ((type == AttributeValueType.breakpoint || type == AttributeValueType.dataBackedbreakpoint) && this.getType() == AttributeValueType.dataBacked) {
            this.attribute.setAttributeValueAsBreakpoint(this);
            this.type = AttributeValueType.dataBackedbreakpoint;
        } else if (type != AttributeValueType.breakpoint || this.type != AttributeValueType.dataBackedbreakpoint) {
            throw new UnsupportedOperationException("Unforeseen combination of states");
        }
    }

    public Attribute getAttribute() {
        return this.attribute;
    }

    public void addTransaction(Transaction t, boolean registerAttributeValue) {
        if (registerAttributeValue) {
            t.registerAttributeValue(this);
        }
        this.transactions.add(t);
    }

    public void removeTransaction(Transaction t) {
        this.transactions.remove(t);
    }

    public Set<Transaction> getTransactions() {
        return Collections.unmodifiableSet(this.transactions);
    }
}

