% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qad.R
\name{qad}
\alias{qad}
\alias{qad.data.frame}
\alias{qad.numeric}
\title{Measure of (asymmetric) dependence}
\usage{
qad(x, ...)

\method{qad}{data.frame}(
  x,
  resolution = NULL,
  permutation = FALSE,
  nperm = 100,
  DoParallel = TRUE,
  registerC = registerDoParallel,
  ncores = NULL,
  print = TRUE,
  ...
)

\method{qad}{numeric}(
  x,
  y,
  resolution = NULL,
  permutation = FALSE,
  nperm = 100,
  DoParallel = TRUE,
  registerC = registerDoParallel,
  ncores = NULL,
  print = TRUE,
  ...
)
}
\arguments{
\item{x}{a data.frame containing two columns with the observations of the bivariate sample or a (non-empty) numeric vector of data values}

\item{...}{Further arguments passed to 'qad' will be ignored}

\item{resolution}{an integer indicating the number of strips for the checkerboard aggregation (see \link{emp_c_copula}).
Default = NULL uses the optimal resolution.}

\item{permutation}{a logical indicating whether a permutated p-value is computed.}

\item{nperm}{an integer indicating the number of permutation runs.}

\item{DoParallel}{a logical value indicating whether the permutation test is computed parallel.}

\item{registerC}{function to register the parallel backend. It is recommended to use registerDoParallel() of the doParallel package (default). Another option for a linux based system is to install the
doMC package and use registerDoMC}

\item{ncores}{an integer indicating the number of cores used for parallel calculation. Default = NULL uses max(cores)-1}

\item{print}{a logical indicating whether the result is printed into the console.}

\item{y}{a (non-empty) numeric vector of data values.}
}
\value{
qad returns an object of class qad containing the following components:
\item{data}{ a data.frame containing the input data.}
\item{results}{ a data.frame containing the results of the dependence measures.}
\item{mass_matrix}{ a matrix containing the mass distribution of the empirical checkerboard copula.}
\item{resolution}{an integer containing the used resolution of the checkerboard aggregation.}
}
\description{
Quantifies the (asymmetric) dependence structure between two random variables X and Y.
}
\details{
qad is a strongly consistent estimator of the copula based dependence measure zeta_1 introduced in Trutschnig 2011.
We first compute the empirical copula of a two-dimensional sample, aggregate it to the so called empirical checkerboard copula (ECB), and
calculate zeta_1 of the ECB copula and its transpose. In order to test for equal dependence in both directions a permutation test based p-value is calculated.
}
\note{
The permutated p-values take some time. We suggest to run the function \code{qad()} without permutation at first.
}
\examples{
#Example 1 (independence)

n <- 1000
x <- runif(n,0,1)
y <- runif(n,0,1)
sample <- data.frame(x,y)
qad(sample)

###

#Example 2 (mutual complete dependence)

n <- 1000
x <- runif(n,0,1)
y <- x^2
sample <- data.frame(x,y)
qad(sample)

#Example 3 (complete dependence)

n <- 1000
x <- runif(n,-10,10)
y <- sin(x)
sample <- data.frame(x,y)
qad(sample)
}
\references{
Trutschnig, W. (2011). On a strong metric on the space of copulas and its induced dependence measure, Journal of Mathematical Analysis and Applications 384, 690-705.
}
