% Generated by roxygen2 (4.0.2): do not edit by hand
\name{rm_white}
\alias{rm_white}
\alias{rm_white_bracket}
\alias{rm_white_colon}
\alias{rm_white_comma}
\alias{rm_white_endmark}
\alias{rm_white_lead}
\alias{rm_white_lead_trail}
\alias{rm_white_multiple}
\alias{rm_white_punctuation}
\alias{rm_white_trail}
\title{Remove/Replace/Extract White Space}
\usage{
rm_white(text.var, trim = FALSE, clean = FALSE, pattern = "@rm_white",
  replacement = "", extract = FALSE,
  dictionary = getOption("regex.library"), ...)

rm_white_bracket(text.var, trim = !extract, clean = TRUE,
  pattern = "@rm_white_bracket", replacement = "", extract = FALSE,
  dictionary = getOption("regex.library"), ...)

rm_white_colon(text.var, trim = !extract, clean = TRUE,
  pattern = "@rm_white_colon", replacement = "", extract = FALSE,
  dictionary = getOption("regex.library"), ...)

rm_white_comma(text.var, trim = !extract, clean = TRUE,
  pattern = "@rm_white_comma", replacement = "", extract = FALSE,
  dictionary = getOption("regex.library"), ...)

rm_white_endmark(text.var, trim = !extract, clean = TRUE,
  pattern = "@rm_white_endmark", replacement = "", extract = FALSE,
  dictionary = getOption("regex.library"), ...)

rm_white_lead(text.var, trim = FALSE, clean = FALSE,
  pattern = "@rm_white_lead", replacement = "", extract = FALSE,
  dictionary = getOption("regex.library"), ...)

rm_white_lead_trail(text.var, trim = FALSE, clean = FALSE,
  pattern = "@rm_white_lead_trail", replacement = "", extract = FALSE,
  dictionary = getOption("regex.library"), ...)

rm_white_trail(text.var, trim = FALSE, clean = FALSE,
  pattern = "@rm_white_trail", replacement = "", extract = FALSE,
  dictionary = getOption("regex.library"), ...)

rm_white_multiple(text.var, trim = !extract, clean = TRUE,
  pattern = "@rm_white_multiple", replacement = "", extract = FALSE,
  dictionary = getOption("regex.library"), ...)

rm_white_punctuation(text.var, trim = !extract, clean = TRUE,
  pattern = "@rm_white_punctuation", replacement = "", extract = FALSE,
  dictionary = getOption("regex.library"), ...)
}
\arguments{
\item{text.var}{The text variable.}

\item{trim}{logical.  If \code{TRUE} removes leading and trailing white
spaces.}

\item{clean}{trim logical.  If \code{TRUE} extra white spaces and escaped
character will be removed.}

\item{pattern}{A character string containing a regular expression (or
character string for \code{fixed = TRUE}) to be matched in the given
character vector.  Default, \code{@rm_dollar} uses the
\code{rm_dollar} regex from the regular expression dictionary from
the \code{dictionary} argument.}

\item{replacement}{Replacement for matched \code{pattern}.}

\item{extract}{logical.  If \code{TRUE} the dollar strings are extracted into a
list of vectors.}

\item{dictionary}{A dictionary of canned regular expressions to search within
if \code{pattern} begins with \code{"@rm_"}.}

\item{\dots}{Other arguments passed to \code{\link[base]{gsub}}.}
}
\value{
Returns a character string with extra white space removed.
}
\description{
\code{rm_white} - Remove multiple white space (> 1 becomes a single white
space), white space before a comma, white space before a single or
consecutive combination of a colon, semicolon, or endmark (period, question
mark, or exclamation point), white space after a left bracket ("{", "(", "[")
or before a right bracket ("}", ")", "]"), leading or trailing white space.

\code{rm_white_bracket} - Remove white space after a left bracket ("{", "(", "[")
or before a right bracket ("}", ")", "]").

\code{rm_white_colon} - Remove white space before a single or consecutive
combination of a colon, semicolon.

\code{rm_white_comma} - Remove white space before a comma.

\code{rm_white_endmark} - Remove white space before endmark(s) (".", "?", "!").

\code{rm_white_lead} - Remove leading white space.

\code{rm_white_lead_trail} - Remove leading or trailing white space.

\code{rm_white_trail} - Remove trailing white space.

\code{rm_white_multiple} - Remove multiple white space (> 1 becomes a single
white space).

\code{rm_white_punctuation} - Remove multiple white space before a comma, white
space before a single or consecutive combination of a colon, semicolon, or
endmark (period, question mark, or exclamation point).
}
\examples{
x <-  c(" There is ( $5.50 ) for , me . ", " that's [ 45.6\% ] of! the pizza !",
    "     14\% is { $26  } or $25.99 ?", "Oh ;  here's colon : Yippee !")

rm_white(x)
rm_white_bracket(x)
rm_white_colon(x)
rm_white_comma(x)
rm_white_endmark(x)
rm_white_lead(x)
rm_white_trail(x)
rm_white_lead_trail(x)
rm_white_multiple(x)
rm_white_punctuation(x)
}
\author{
\code{rm_white_endmark}/\code{rm_white_punctuation} - \href{http://stackoverflow.com}{stackoverflow}'s hwnd and Tyler Rinker <tyler.rinker@gmail.com>.
}
\references{
The \code{rm_white_endmark}/\code{rm_white_punctuation} regular expression was taken from:
\url{http://stackoverflow.com/a/25464921/1000343}
}
\seealso{
\code{\link[base]{gsub}},
\code{\link[stringi]{stri_extract_all_regex}}
}
\keyword{percent}

