% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qfa4.1.R
\name{sqr.fit}
\alias{sqr.fit}
\title{Spline Quantile Regression (SQR)}
\usage{
sqr.fit(
  X,
  y,
  tau,
  spar = 1,
  d = 1,
  weighted = FALSE,
  mthreads = TRUE,
  ztol = 1e-05
)
}
\arguments{
\item{X}{design matrix (\code{nrow(X) = length(y)})}

\item{y}{response vector}

\item{tau}{sequence of quantile levels in (0,1)}

\item{spar}{smoothing parameter}

\item{d}{subsampling rate of quantile levels (default = 1)}

\item{weighted}{if \code{TRUE}, penalty function is weighted (default = \code{FALSE})}

\item{mthreads}{if \code{FALSE}, set \code{RhpcBLASctl::blas_set_num_threads(1)} (default = \code{TRUE})}

\item{ztol}{zero tolerance parameter used to determine the effective dimensionality of the fit}
}
\value{
A list with the following elements:
  \item{coefficients}{matrix of regression coefficients}
  \item{crit}{sequence critera for smoothing parameter select: (AIC,BIC)}
  \item{np}{sequence of number of effective parameters}
  \item{fid}{sequence of fidelity measure as quasi-likelihood}
  \item{nit}{number of iterations}
}
\description{
This function computes spline quantile regression (SQR) solution from response vector and design matrix.
It uses the FORTRAN code \code{rqfnb.f} in the "quantreg" package with the kind permission of Dr. R. Koenker.
}
