% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/base_multinomial.R
\name{msm_multinomial_fit}
\alias{msm_multinomial_fit}
\title{Fitting marginal structural model (MSM) within quantile g-computation}
\usage{
msm_multinomial_fit(
  f,
  qdata,
  intvals,
  expnms,
  main = TRUE,
  degree = 1,
  id = NULL,
  weights,
  bayes = FALSE,
  MCsize = nrow(qdata),
  hasintercept = TRUE,
  ...
)
}
\arguments{
\item{f}{an r formula representing the conditional model for the outcome, given all
exposures and covariates. Interaction terms that include exposure variables
should be represented via the \code{\link[base]{AsIs}} function}

\item{qdata}{a data frame with quantized exposures}

\item{intvals}{sequence, the sequence of integer values that the joint exposure
is 'set' to for estimating the msm. For quantile g-computation, this is just
0:(q-1), where q is the number of quantiles of exposure.}

\item{expnms}{a character vector with the names of the columns in qdata that represent
the exposures of interest (main terms only!)}

\item{main}{logical, internal use: produce estimates of exposure effect (psi)
and expected outcomes under g-computation and the MSM}

\item{degree}{polynomial bases for marginal model (e.g. degree = 2
allows that the relationship between the whole exposure mixture and the outcome
is quadratic. Default=1)}

\item{id}{(optional) NULL, or variable name indexing individual units of
observation (only needed if analyzing data with multiple observations per
id/cluster)}

\item{weights}{"case weights" - passed to the "weight" argument of
\code{\link[stats]{glm}} or \code{\link[arm]{bayesglm}}}

\item{bayes}{use underlying Bayesian model (\code{arm} package defaults). Results
in penalized parameter estimation that can help with very highly correlated
exposures. Note: this does not lead to fully Bayesian inference in general,
so results should be interpreted as frequentist.}

\item{MCsize}{integer: sample size for simulation to approximate marginal
zero inflated model parameters. This can be left small for testing, but should be as large
as needed to reduce simulation error to an acceptable magnitude (can compare psi coefficients for
linear fits with qgcomp.zi.noboot to gain some intuition for the level of expected simulation
error at a given value of MCsize)}

\item{hasintercept}{(logical) does the model have an intercept?}

\item{...}{arguments to glm (e.g. family)}
}
\description{
This is an internal function called by \code{\link[qgcomp]{qgcomp.multinomial.boot}},
but is documented here for clarity. Generally, users will not need to call
this function directly.
}
\details{
This function first computes expected outcomes under hypothetical
interventions to simultaneously set all exposures to a specific quantile. These
predictions are based on g-computation, where the exposures are `quantized',
meaning that they take on ordered integer values according to their ranks,
and the integer values are determined by the number of quantile cutpoints used.
The function then takes these expected outcomes and fits an additional model
(a marginal structural model) with the expected outcomes as the outcome and
the intervention value of the exposures (the quantile integer) as the exposure.
Under causal identification assumptions and correct model specification,
the MSM yields a causal exposure-response representing the incremental
change in the expected outcome given a joint intervention on all exposures.
}
\examples{
data("metals") # from qgcomp package
# create categorical outcome from the existing continuous outcome (usually, one will already exist)
metals$ycat = factor(quantize(metals, "y",q=4)$data$y, levels=c("0", "1", "2", "3"), 
                     labels=c("cct", "ccg", "aat", "aag")) 
# restrict to smaller dataset for simplicity
smallmetals = metals[,c("ycat", "arsenic", "lead", "cadmium", "mage35")]

### 1: Define mixture and underlying model ####
mixture = c("arsenic", "lead", "cadmium")
f0 = ycat ~ arsenic + lead + cadmium # the multinomial model 
# (be sure that factor variables are properly coded ahead of time in the dataset)
qdat <- quantize(smallmetals, mixture, q=4)$data
mod <- msm_multinomial_fit(f0,
        expnms = mixture, qdata=qdat, intvals=1:4, bayes=FALSE)
summary(mod$fit) # outcome regression model
summary(mod$msmfit) # msm fit (variance not valid - must be obtained via bootstrap)
}
\seealso{
\code{\link[qgcomp]{qgcomp.glm.boot}}, and \code{\link[qgcomp]{qgcomp}}
}
\concept{variance mixtures}
