% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/base_utility.R
\name{getstrateffects}
\alias{getstrateffects}
\title{Calculate mixture effect at a set value of effect measure modifier}
\usage{
getstrateffects(x, emmval = 1, ...)
}
\arguments{
\item{x}{"qgcompemmfit" object from qgcomp.emm.glm.noboot
function}

\item{emmval}{numerical: value of effect measure modifier at which weights are generated}

\item{...}{unused}
}
\value{
An object of class "qgcompemmeffects", which inherits from "qgcompemmfit" and "list"

This class contains the \code{emmval}-stratum specific effect estimates of the mixture. By default, this prints a coefficient table, similar to objects of type "qgcompemmfit" which displays the stratum specific joint effects from a "qgcompemmfit" model.
}
\description{
A standard qgcomp fit with effect measure modification
only estimates effects at the referent (0) level of the modifier (psi1).
This function can be used to estimate effects at arbitrary levels of the modifier
}
\examples{
dat <- data.frame(y=runif(50), x1=runif(50), x2=runif(50),
  z=rbinom(50, 1, 0.5), r=rbinom(50, 1, 0.5))
(qfit <- qgcomp.emm.glm.noboot(f=y ~ z + x1 + x2, emmvar="z",
  expnms = c('x1', 'x2'), data=dat, q=2, family=gaussian()))
getstrateffects(qfit, emmval = 0)
strateffects = getstrateffects(qfit, emmval = 1)

}
\seealso{
\code{\link[qgcompint]{qgcomp.emm.glm.noboot}} \code{\link[qgcompint]{getstratweights}}
}
\concept{variance mixtures}
