% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QQIDexample.R
\name{QQIDexample}
\alias{QQIDexample}
\title{QQIDexample}
\usage{
QQIDexample(sel = 1:5)
}
\arguments{
\item{sel}{(numeric, or logical) a subsetting vector}
}
\value{
(character) a vector of QQIDs
}
\description{
\code{QQIDexample} returns synthetic, valid QQIDs for testing and
development. The synthetic examples are easy to distinguish from "real" IDs
to prevent their accidental use in an application.
}
\details{
The function stores five artificial QQIDs. Input is an index vector that
specifies which QQIDs to return. More than five IDs can be requested by
applying the usual subsetting rules. The QQIDs represent the exact same
numbers provided by \code{\link[=xltIDexample]{xltIDexample()}}. However the \code{qqid}
package provides only format conversion to UUID at this time, so the reverse
comparison will only succeed with \code{xltIDexample("UUID")}.
}
\examples{
QQIDexample()                                  # the five stored QQIDs
QQIDexample(2:3)                               # two QQIDS
QQIDexample(c(TRUE, FALSE))                    # vector recycling
QQIDexample(sample(1:5, 17, replace = TRUE))   # seventeen in random order
QQIDexample() == xlt2qq(xltIDexample())        # TRUE TRUE TRUE TRUE TRUE

}
\seealso{
\code{\link[=xltIDexample]{xltIDexample()}} Returns five 128-bit "hexlets", formatted
  as Md5, hex-number, UUID, and IPv6.
}
\author{
(c) 2019 \href{https://orcid.org/0000-0002-1134-6758}{Boris Steipe},
licensed under MIT (see file \code{LICENSE} in this package).
}
