% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reptools.r
\name{runDeriveExpr}
\alias{runDeriveExpr}
\title{runDeriveExpr}
\usage{
runDeriveExpr(d, derv, pr = TRUE)
}
\arguments{
\item{d}{a data table}

\item{derv}{a \code{list} of expressions to evaluate}

\item{pr}{set \code{pr=FALSE} to suppress information messages}
}
\value{
nothing; used to print information and add variables to data table
}
\description{
Apply Derived Variable Specifications
}
\details{
Function to apply derived variable specifications derv to a data table \code{d}.   Actions on \code{d} are done in place, so call the function using \verb{runDeriveExpr(d, derv object)} and not by running \verb{d <- runDeriveExpr(d, derv object)}.
See \href{https://hbiostat.org/rflow/manip.html#sec-manip-recexp/}{this} for an example.
}
\examples{
require(data.table)
d <- data.table(ht=c(68,  60), wt=c(280, 135), chol=c(120, 150))
derived <- list(
  list(bmi = expression(703 * wt / ht ^ 2),
       label='Body Mass Index',
       units='Kg/m^2'),
  list(bsa=expression(0.007184 * (0.4536 * wt) ^ 0.425 * (2.54 * ht) ^ 0.725),
       label='Body Surface Area',
       units='m^2', drop=.q(wt, ht) )   )
runDeriveExpr(d, derived)
print(d)
contents(d)
}
\author{
Frank Harrell
}
