% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.r
\name{setqreportOption}
\alias{setqreportOption}
\title{Set qreport Options}
\usage{
setqreportOption(..., study = " ")
}
\arguments{
\item{\dots}{a series of options for which non-default values are desired:
\itemize{
\item{\code{tx.pch}:}{symbols corresponding to treatments}
\item{\code{tx.col}:}{colors corresponding to treatments}
\item{\code{tx.linecol}:}{colors for lines in line plots}
\item{\code{nontx.col}:}{colors for categories other than treatments}
\item{\code{tx.lty}:}{line types corresponding to treatments}
\item{\code{tx.lwd}:}{line widths corresponding to treatments}
\item{\code{tx.var}:}{character string name of treatment variable}
\item{\code{er.col}:}{2-vector with names \code{"enrolled","randomized"} containing colors to use for enrolled and randomized in needle displays}
\item{\code{alpha.f}:}{single numeric specifying alpha adjustment to be applied to all colors.  Default is 1 (no adjustment)}
\item{\code{denom}:}{named vector with overall sample sizes}
}
See https://github.com/plotly/plotly.py/blob/master/plotly/colors.py#L83-L87/}

\item{study}{an optional study mnemonic (character string) needed when multiple studies are being analyzed (or when one study is divided into distinct strata)}
}
\value{
no returned value, used to set \code{options()}
}
\description{
Set qreport Options
}
\examples{
setqreportOption(tx.var='treatment', denom=c(enrolled=1000, randomized=800, a=398, b=402))
}
