% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/symmetricPolynomials.R
\docType{methods}
\name{compactSymmetricQspray}
\alias{compactSymmetricQspray}
\alias{compactSymmetricQspray,qspray,logical-method}
\alias{compactSymmetricQspray,qspray-method}
\alias{compactSymmetricQspray,qspray,ANY-method}
\title{Compact symmetric qspray}
\usage{
\S4method{compactSymmetricQspray}{qspray,logical}(qspray, check)

\S4method{compactSymmetricQspray}{qspray,ANY}(qspray)
}
\arguments{
\item{qspray}{a \code{qspray} object, which should correspond to a 
symmetric polynomial}

\item{check}{Boolean, whether to check the symmetry (default \code{TRUE})}
}
\value{
A character string.
}
\description{
Prints a symmetric qspray polynomial as a linear combination of 
  the monomial symmetric polynomials.
}
\examples{
library(qspray)
( qspray <- PSFpoly(4, c(3, 1)) - ESFpoly(4, c(2, 2)) + 4L )
compactSymmetricQspray(qspray, check = TRUE)
}
\seealso{
\code{\link{MSPcombination}}
}
