% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ciqte.R
\name{ci.qte}
\alias{ci.qte}
\title{ci.qte}
\usage{
ci.qte(formla, xformla = NULL, x = NULL, data, w = NULL,
  probs = seq(0.05, 0.95, 0.05), se = TRUE, iters = 100, alp = 0.05,
  plot = FALSE, method = "logit", retEachIter = FALSE, seedvec = NULL,
  printIter = FALSE, pl = FALSE, cores = 2)
}
\arguments{
\item{formla}{The formula y ~ d where y is the outcome and d is the
treatment indicator (d should be binary)}

\item{xformla}{A optional one sided formula for additional covariates that
will be adjusted for.  E.g ~ age + education.  Additional covariates can
also be passed by name using the x paramater.}

\item{x}{Vector of covariates.  Default is no covariates}

\item{data}{The name of the data.frame that contains the data}

\item{w}{an additional vector of sampling weights}

\item{probs}{A vector of values between 0 and 1 to compute the QTET at}

\item{se}{Boolean whether or not to compute standard errors}

\item{iters}{The number of iterations to compute bootstrap standard errors.
This is only used if se=TRUE}

\item{alp}{The significance level used for constructing bootstrap
confidence intervals}

\item{plot}{Boolean whether or not the estimated QTET should be plotted}

\item{method}{Method to compute propensity score.  Default is logit; other
option is probit.}

\item{retEachIter}{Boolean whether or not to return list of results
from each iteration of the bootstrap procedure}

\item{seedvec}{Optional value to set random seed; can possibly be used
in conjunction with bootstrapping standard errors.}

\item{printIter}{For debugging only; should leave at default FALSE unless
you want to see a lot of output}

\item{pl}{boolean for whether or not to compute bootstrap error in parallel.
Note that computing standard errors in parallel is a new feature and may
not work at all on Windows.}

\item{cores}{the number of cores to use if bootstrap standard errors are
computed in parallel}
}
\value{
QTE object
}
\description{
The \code{ci.qtet} method implements estimates the Quantile
Treatment Effect (QTE) under a Conditional Independence
Assumption (sometimes this is called Selection on Observables) developed
in Firpo (2007).  This method using propensity score re-weighting
and minimizes a check function to compute the QTET.  Standard errors
(if requested) are computed using the bootstrap.
}
\examples{
## Load the data
data(lalonde)

##Estimate the QTET of participating in the job training program;
##This is the no covariate case.  Note: Because individuals that participate
## in the job training program are likely to be much different than
## individuals that do not (e.g. less experience and less education), this
## method is likely to perform poorly at estimating the true QTET
q1 <- ci.qte(re78 ~ treat, x=NULL, data=lalonde.psid, se=FALSE,
 probs=seq(0.05,0.95,0.05))
summary(q1)

##This estimation controls for all the available background characteristics.
q2 <- ci.qte(re78 ~ treat,
 xformla=~age + I(age^2) + education + black + hispanic + married + nodegree,
 data=lalonde.psid, se=FALSE, probs=seq(0.05, 0.95, 0.05))
summary(q2)

}
\references{
Firpo, Sergio.   ``Efficient Semiparametric Estimation of Quantile Treatment
 Effects.'' Econometrica 75.1, pp. 259-276, 2015.
}
