% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_control_file.R
\name{write_control_file}
\alias{write_control_file}
\title{Write a control file for QTL data}
\usage{
write_control_file(
  output_file,
  crosstype = NULL,
  geno_file = NULL,
  founder_geno_file = NULL,
  gmap_file = NULL,
  pmap_file = NULL,
  pheno_file = NULL,
  covar_file = NULL,
  phenocovar_file = NULL,
  sex_file = NULL,
  sex_covar = NULL,
  sex_codes = NULL,
  crossinfo_file = NULL,
  crossinfo_covar = NULL,
  crossinfo_codes = NULL,
  geno_codes = NULL,
  alleles = NULL,
  xchr = NULL,
  sep = ",",
  na.strings = c("-", "NA"),
  comment.char = "#",
  geno_transposed = FALSE,
  founder_geno_transposed = FALSE,
  pheno_transposed = FALSE,
  covar_transposed = FALSE,
  phenocovar_transposed = FALSE,
  description = NULL,
  comments = NULL,
  overwrite = FALSE
)
}
\arguments{
\item{output_file}{File name (with path) of the
\href{https://yaml.org}{YAML} or \href{https://json.org}{JSON} file to be created, as a character
string. If extension is \code{.json}, JSON format is used; otherwise, YAML is used.}

\item{crosstype}{Character string with the cross type.}

\item{geno_file}{File name for genotype data.}

\item{founder_geno_file}{File name for the founder genotype data.}

\item{gmap_file}{File name for genetic map.}

\item{pmap_file}{File name for the physical map.}

\item{pheno_file}{File name for the phenotype data.}

\item{covar_file}{File name for the covariate data.}

\item{phenocovar_file}{File name for the phenotype covariate data
(i.e., metadata about the phenotypes).}

\item{sex_file}{File name for the individuals' sex. (Specify just
one of \code{sex_file} or \code{sex_covar}.)}

\item{sex_covar}{Column name in the covariate data that corresponds
to sex. (Specify just one of \code{sex_file} or \code{sex_covar}.)}

\item{sex_codes}{Named vector of character strings specifying the
encoding of sex. The names attribute should be the codes used in
the data files; the values within the vector should be
\code{"female"} and \code{"male"}.}

\item{crossinfo_file}{File name for the \code{cross_info} data. (Specify just
one of \code{crossinfo_file} or \code{crossinfo_covar}.)}

\item{crossinfo_covar}{Column name in the covariate data that
corresponds to the \code{cross_info} data. (Specify just one of
\code{crossinfo_file} or \code{crossinfo_covar}.)}

\item{crossinfo_codes}{In the case that there is a single cross
info column (whether in a file or as a covariate), you can
provide a named vector of character strings specifying the
encoding of \code{cross_info}. The names attribute should be the
codes used; the values within the vector should be the codes to
which they will be converted (for example, \code{0} and \code{1} for an
intercross).}

\item{geno_codes}{Named vector specifying the encoding of
genotypes. The names attribute has the codes used within the
genotype and founder genotype data files; the values within the
vector should be the integers to which the genotypes will be
converted.}

\item{alleles}{Vector of single-character codes for the founder
alleles.}

\item{xchr}{Character string with the ID for the X chromosome.}

\item{sep}{Character string that separates columns in the data files.}

\item{na.strings}{Vector of character strings with codes to be
treated as missing values.}

\item{comment.char}{Character string that is used as initial
character in a set of leading comment lines in the data files.}

\item{geno_transposed}{If TRUE, genotype file is transposed (with markers as rows).}

\item{founder_geno_transposed}{If TRUE, founder genotype file is transposed (with markers as rows).}

\item{pheno_transposed}{If TRUE, phenotype file is transposed (with phenotypes as rows).}

\item{covar_transposed}{If TRUE, covariate file is transposed (with covariates as rows).}

\item{phenocovar_transposed}{If TRUE, phenotype covariate file is transposed (with phenotype covariates as rows).}

\item{description}{Optional character string describing the data.}

\item{comments}{Vector of character strings to be inserted as
comments at the top of the file (in the case of YAML), with each
string as a line. For JSON, the comments are instead included
within the control object.}

\item{overwrite}{If TRUE, overwrite file if it exists. If FALSE
(the default) and the file exists, stop with an error.}
}
\value{
(Invisibly) The data structure that was written.
}
\description{
Write the control file (in \href{https://yaml.org}{YAML} or \href{https://json.org}{JSON}) needed
by \code{\link[=read_cross2]{read_cross2()}} for a set of QTL data.
}
\details{
This function takes a set of parameters and creates the
control file (in \href{https://yaml.org}{YAML} or \href{https://json.org}{JSON} format) needed
for the new input data file format for
\href{https://kbroman.org/qtl2}{R/qtl2}.  See the
\href{https://kbroman.org/qtl2/pages/sampledata.html}{sample data files} and the
\href{https://kbroman.org/qtl2/assets/vignettes/input_files.html}{vignette describing the input file format}.
}
\examples{
# Control file for the sample dataset, grav2
grav2_control_file <- file.path(tempdir(), "grav2.yaml")
write_control_file(grav2_control_file,
                   crosstype="riself",
                   geno_file="grav2_geno.csv",
                   gmap_file="grav2_gmap.csv",
                   pheno_file="grav2_pheno.csv",
                   phenocovar_file="grav2_phenocovar.csv",
                   geno_codes=c(L=1L, C=2L),
                   alleles=c("L", "C"),
                   na.strings=c("-", "NA"))

# Control file for the sample dataset, iron
iron_control_file <- file.path(tempdir(), "iron.yaml")
write_control_file(iron_control_file,
                   crosstype="f2",
                   geno_file="iron_geno.csv",
                   gmap_file="iron_gmap.csv",
                   pheno_file="iron_pheno.csv",
                   covar_file="iron_covar.csv",
                   phenocovar_file="iron_phenocovar.csv",
                   geno_codes=c(SS=1L, SB=2L, BB=3L),
                   sex_covar="sex",
                   sex_codes=c(f="female", m="male"),
                   crossinfo_covar="cross_direction",
                   crossinfo_codes=c("(SxB)x(SxB)"=0L, "(BxS)x(BxS)"=1L),
                   xchr="X",
                   alleles=c("S", "B"),
                   na.strings=c("-", "NA"))

# Remove these files, to clean up temporary directory
unlink(c(grav2_control_file, iron_control_file))
}
\seealso{
\code{\link[=read_cross2]{read_cross2()}}, sample data files at
\url{https://kbroman.org/qtl2/pages/sampledata.html}
}
\keyword{utilities}
