% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/probs_to_grid.R
\name{probs_to_grid}
\alias{probs_to_grid}
\title{Subset genotype probability array to pseudomarkers on a grid}
\usage{
probs_to_grid(probs, grid)
}
\arguments{
\item{probs}{Genotype probabilities as output from
\code{\link[=calc_genoprob]{calc_genoprob()}} with \code{stepwidth="fixed"}.}

\item{grid}{List of logical vectors that indicate which positions
are on the grid and should be retained.}
}
\value{
An object of class \code{"calc_genoprob"}, like the input, subset to just include
pseudomarkers along a grid. See \code{\link[=calc_genoprob]{calc_genoprob()}}.
}
\description{
Subset genotype probability array (from \code{\link[=calc_genoprob]{calc_genoprob()}}
to a grid of pseudomarkers along each chromosome.
}
\details{
This only works if \code{\link[=calc_genoprob]{calc_genoprob()}} was run
with \code{stepwidth="fixed"}, so that the genotype
probabilities were calculated at a grid of
markers/pseudomarkers. When this is the case, we omit all but
the probabilities on this grid. Use \code{\link[=calc_grid]{calc_grid()}} to
find the grid positions.
}
\examples{
grav2 <- read_cross2(system.file("extdata", "grav2.zip", package="qtl2"))
map_w_pmar <- insert_pseudomarkers(grav2$gmap, step=1)
probs <- calc_genoprob(grav2, map_w_pmar, error_prob=0.002)
sapply(probs, dim)
grid <- calc_grid(grav2$gmap, step=1)
probs_sub <- probs_to_grid(probs, grid)
sapply(probs_sub, dim)
}
\seealso{
\code{\link[=calc_grid]{calc_grid()}}, \code{\link[=map_to_grid]{map_to_grid()}}
}
\keyword{utilities}
