% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_consensus_geno.R
\name{find_consensus_geno}
\alias{find_consensus_geno}
\title{Find the consensus genotype for each row of a genotype matrix}
\usage{
find_consensus_geno(genotypes, na.strings = c("N", "H", "NA", ""), cores = 1)
}
\arguments{
\item{genotypes}{Matrix of genotypes (markers x individuals)}

\item{na.strings}{Genotypes to be considered as missing values.}

\item{cores}{Number of CPU cores to use, for parallel calculations.
(If \code{0}, use \code{\link[parallel:detectCores]{parallel::detectCores()}}.)
Alternatively, this can be links to a set of cluster sockets, as
produced by \code{\link[parallel:makeCluster]{parallel::makeCluster()}}.}
}
\value{
Vector of consensus genotypes, one value per row of \code{genotypes}
}
\description{
For genotype data (markers x individuals) on a set of individuals
from a single inbred line, find the consensus genotype at each
marker.
}
\examples{
g <- rbind(c("NA", "N", "A", "A", "T", "G", NA, "H"),
           c("C",  "C", "G", "G", "A", NA,  NA, NA),
           rep(NA, 8),
           c("C", "C", "G", "G", "G", "C", "G", "G"))
consensus <- find_consensus_geno(g)
}
\seealso{
\code{\link[=find_unique_geno]{find_unique_geno()}}, \code{\link[=encode_geno]{encode_geno()}}
}
