% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/feature_tbl.R, R/ggplot_feature_tbl.R
\name{summary.feature_tbl}
\alias{summary.feature_tbl}
\alias{subset.feature_tbl}
\alias{ggplot_feature_tbl}
\alias{autoplot.feature_tbl}
\title{Summary of features}
\usage{
\method{summary}{feature_tbl}(object, major = TRUE, ...)

\method{subset}{feature_tbl}(x, start_val = 0, stop_val = max(x$stop), ...)

ggplot_feature_tbl(
  x,
  rect_col = "grey70",
  strand_col = c(`-` = "#1b9e77", `+` = "#d95f02"),
  type_col = c(gene = "black", pseudogene = "#1b9e77", other = "#d95f02"),
  text_size = 3,
  xlim = NULL,
  snp_pos = top_snps_tbl$pos,
  snp_lod = top_snps_tbl$lod,
  top_snps_tbl = NULL,
  snp_col = "grey70",
  extend = 0.005,
  ...
)

\method{autoplot}{feature_tbl}(x, ...)
}
\arguments{
\item{object}{tbl of feature information from \code{\link[qtl2]{create_gene_query_func}}}

\item{major}{if \code{TRUE} (default), only summarize genes and exons}

\item{...}{additional arguments (not used)}

\item{x}{tbl of gene information from \code{query_variants}; see \code{\link[qtl2]{create_variant_query_func}}}

\item{start_val, stop_val}{start and stop positions for subset}

\item{rect_col}{fill color of rectangle (default "grey70")}

\item{strand_col}{edge color of rectangle by strand from \code{x} (default -="blue", +="red"; none if NULL)}

\item{type_col}{color of type from \code{x} (default "black" for gene, "blue" for pseudogene; none if NULL)}

\item{text_size}{size of text (default 3)}

\item{xlim}{horizontal axis limits (default is range of features)}

\item{snp_pos}{position of SNPs in bp if used (default NULL)}

\item{snp_lod}{LOD of SNPs (for color plotting)}

\item{top_snps_tbl}{table from \code{\link[qtl2]{top_snps}}}

\item{snp_col}{color of SNP vertical lines (default "grey70")}

\item{extend}{extend region for SNPs in bp (default 0.005)}
}
\value{
tbl of feature summaries by type

tbl of feature summaries by type

data frame of gene information (invisible)
}
\description{
Show count min and max of features by type

Plot genes as rectangles followed by names.
Stagger genes for easy reading.
Written original by Dan Gatti 2013-02-13
}
\references{
\url{https://github.com/dmgatti/DOQTL/blob/master/R/gene.plot.R}
}
\author{
Brian S Yandell, \email{brian.yandell@wisc.edu}

Brian S Yandell, \email{brian.yandell@wisc.edu}

Brian S Yandell, \email{brian.yandell@wisc.edu}
   Daniel Gatti, \email{Dan.Gatti@jax.org}
}
\keyword{hplot}
\keyword{utilities}
