% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_covs.R
\name{calc_covs}
\alias{calc_covs}
\title{Calculate Vg and Ve from d-variate phenotype and kinship}
\usage{
calc_covs(pheno, kinship, X1pre = rep(1, nrow(kinship)),
  max_iter = 1e+06, max_prec = 1/1e+08, covariates = NULL)
}
\arguments{
\item{pheno}{n by d matrix of phenotypes}

\item{kinship}{a kinship matrix, n by n}

\item{X1pre}{n by c design matrix. c = 1 to ignore genotypes}

\item{max_iter}{maximum number of EM iterations}

\item{max_prec}{maximum precision for stepwise increments in EM algorithm}

\item{covariates}{a n by n.cov matrix of numeric covariates}
}
\value{
a list with 2 named components, Vg and Ve. Each is a d by d covariance matrix.
}
\description{
Calculate Vg and Ve from d-variate phenotype and kinship
}
\examples{
calc_covs(pheno = matrix(data = rnorm(100), nrow = 50, ncol = 2), kinship = diag(50))
}
