% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/profile_qtl.R
\name{profile_qtl}
\alias{profile_qtl}
\alias{print.qtlpoly.profile}
\title{QTL profiling}
\usage{
profile_qtl(
  data,
  model,
  d.sint = 1.5,
  polygenes = FALSE,
  n.clusters = NULL,
  plot = NULL,
  verbose = TRUE
)

\method{print}{qtlpoly.profile}(x, pheno.col = NULL, sint = NULL, ...)
}
\arguments{
\item{data}{an object of class \code{qtlpoly.data}.}

\item{model}{an object of class \code{qtlpoly.model} containing the QTL to be profiled.}

\item{d.sint}{a \eqn{d} value to subtract from logarithm of \emph{p}-value (\eqn{LOP-d}) for support interval calculation, e.g. \eqn{d=1.5} (default) represents approximate 95\% support interval.}

\item{polygenes}{if \code{TRUE} all QTL but the one being tested are treated as a single polygenic effect, if \code{FALSE} (default) all QTL effect variances have to estimated.}

\item{n.clusters}{number of parallel processes to spawn.}

\item{plot}{a suffix for the file's name containing plots of every QTL profiling round, e.g. "profile" (default); if \code{NULL}, no file is produced.}

\item{verbose}{if \code{TRUE} (default), current progress is shown; if \code{FALSE}, no output is produced.}

\item{x}{an object of class \code{qtlpoly.profile} to be printed.}

\item{pheno.col}{a numeric vector with the phenotype column numbers to be plotted; if \code{NULL}, all phenotypes from \code{'data'} will be included.}

\item{sint}{whether \code{"upper"} or \code{"lower"} support intervals should be printed; if \code{NULL} (default), only QTL peak information will be printed.}

\item{...}{currently ignored}
}
\value{
An object of class \code{qtlpoly.profile} which contains a list of \code{results} for each trait with the following components:

    \item{pheno.col}{a phenotype column number.}
    \item{stat}{a vector containing values from score statistics.}
    \item{pval}{a vector containing \emph{p}-values from score statistics.}
    \item{qtls}{a data frame with information from the mapped QTL.}
    \item{lower}{a data frame with information from the lower support interval of mapped QTL.}
    \item{upper}{a data frame with information from the upper support interval of mapped QTL.}
}
\description{
Generates the score-based genome-wide profile conditional to the selected QTL.
}
\examples{
  \donttest{
  # Estimate conditional probabilities using mappoly package
  library(mappoly)
  library(qtlpoly)
  genoprob4x = lapply(maps4x[c(5)], calc_genoprob)
  data = read_data(ploidy = 4, geno.prob = genoprob4x, pheno = pheno4x, step = 1)

  # Build null model
  null.mod = null_model(data, pheno.col = 1, n.clusters = 1)

  # Perform forward search
  search.mod = search_qtl(data = data, model = null.mod,
w.size = 15, sig.fwd = 0.01, n.clusters = 1)

  # Optimize model
  optimize.mod = optimize_qtl(data = data, model = search.mod, sig.bwd = 0.0001, n.clusters = 1)

  # Profile model
  profile.mod = profile_qtl(data = data, model = optimize.mod, d.sint = 1.5, n.clusters = 1)
  }

}
\references{
Pereira GS, Gemenet DC, Mollinari M, Olukolu BA, Wood JC, Mosquera V, Gruneberg WJ, Khan A, Buell CR, Yencho GC, Zeng ZB (2020) Multiple QTL mapping in autopolyploids: a random-effect model approach with application in a hexaploid sweetpotato full-sib population, \emph{Genetics} 215 (3): 579-595. \doi{10.1534/genetics.120.303080}.
    
    Qu L, Guennel T, Marshall SL (2013) Linear score tests for variance components in linear mixed models and applications to genetic association studies. \emph{Biometrics} 69 (4): 883–92.
}
\author{
Guilherme da Silva Pereira, \email{gdasilv@ncsu.edu}
}
