% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DateManipulation.R
\name{BusinessDays}
\alias{BusinessDays}
\title{BusinessDays}
\usage{
BusinessDays(loc = "BOG", from = NULL, to = NULL)
}
\arguments{
\item{loc}{String that determines the location for business days. See details.}

\item{from}{If provided returns available business dates after this date (inclusive).}

\item{to}{If provided returns available business dates until this date (inclusive).}
}
\value{
Vector of business days. Data availability depends on the location.
}
\description{
Calculate business days for a given location. Data availability
depends on the location.
}
\details{
loc refers to the location for business days:
 \itemize{
     \item NY for New York.
     \item LDN for London.
     \item NYLDN for the intersection of business days in New York and London.
     \item BOG for Bogota.
     \item BOGNY for the intersection of business days in Bogota and New York.
}
}
\examples{
# Returns all business days available for the location
BusinessDays(loc='BOG')

# Returns business days within given range for the location and Dates as
# character
BusinessDays(loc='BOG', from='2020-10-10', to='2020-11-10')

# Returns business days within given range for the location and Dates as
# Dates
BusinessDays(loc='BOG', from=as.Date('2020-10-10'), to='2020-11-10')

# Returns all available business days for the locatio after given
# 'from' date as character
BusinessDays(loc='BOG', from='2020-10-10')

}
\author{
Diego Jara and Julian Chitiva
}
