% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/textfile.R
\docType{methods}
\name{textfile}
\alias{textfile}
\alias{textfile,character,index,missing,missing,ANY,missing,missing,missing-method}
\alias{textfile,character,missing,ANY,ANY,ANY,missing,missing,missing-method}
\alias{textfile,character,missing,missing,missing,ANY,character,ANY,ANY-method}
\title{read a text corpus source from a file}
\usage{
textfile(file, textField, encodingFrom = NULL, encodingTo = "UTF-8",
  cache = FALSE, docvarsfrom = c("filenames"), dvsep = "_",
  docvarnames = NULL, ...)


  \S4method{textfile}{character,index,missing,missing,ANY,missing,missing,missing}(file,
  textField, encodingFrom = NULL, encodingTo = "UTF-8", cache = FALSE,
  docvarsfrom = c("filenames"), dvsep = "_", docvarnames = NULL, ...)


  \S4method{textfile}{character,missing,ANY,ANY,ANY,missing,missing,missing}(file,
  textField, encodingFrom = NULL, encodingTo = "UTF-8", cache = FALSE,
  docvarsfrom = c("filenames"), dvsep = "_", docvarnames = NULL, ...)


  \S4method{textfile}{character,missing,missing,missing,ANY,character,ANY,ANY}(file,
  textField, encodingFrom = NULL, encodingTo = "UTF-8", cache = FALSE,
  docvarsfrom = c("filenames"), dvsep = "_", docvarnames = NULL, ...)
}
\arguments{
\item{file}{the complete filename to be read.  Currently available file types
are: \describe{ \item{\code{txt}}{plain text files} \item{\code{json}}{data
in JavaScript Object Notation, consisting of the texts and additional
document-level variables and document-level meta-data.  The text key must
be identified by specifying a \code{textField} value.}
\item{\code{csv}}{comma separated value data, consisting of the texts and
additional document-level variables and document-level meta-data.  The text
file must be identified by specifying a \code{textField} value.}
\item{\code{tab, tsv}}{tab-separated value data, consisting of the texts and
additional document-level variables and document-level meta-data.  The text
file must be identified by specifying a \code{textField} value.}
\item{a
wildcard value}{any valid pathname with a wildcard ("glob") expression that
can be expanded by the operating system.  This may consist of multiple file
types.} \item{\code{xml}}{Basic flat XML documents are supported -- those
of the kind supported by the function xmlToDataFrame function of the
\strong{XML}  package.}
\item{\code{zip}}{zip archive file, containing \code{*.txt} files.  This may be
a URL to a zip file.}
}}

\item{textField}{a variable (column) name or column number indicating where
to find the texts that form the documents for the corpus.  This must be
specified for file types \code{.csv} and \code{.json}.}

\item{encodingFrom}{a single character value specifying the input file
encoding, or a vector of character values where each element corresponds to
a single file, if a filemask or multiple filenames are supplied as
\code{file}.  These work in the same was as the \code{encoding} argument
supplied to \link{file}, which uses the naming conventions and conversion
functions of \link{iconv}.  If no \code{encodingFrom} argument is supplied,
then the default encoding is assumed, which may very well be incorrect.
Currently, this argument only works when reading text (\code{txt}) files.}

\item{encodingTo}{an optional value that can specify the encoding you wish
the files to be converted to, but we strongly encourage you to use the
default of UTF-8.}

\item{cache}{If \code{TRUE}, write the object to a temporary file and store
the temporary filename in the \link{corpusSource-class} object definition.
If \code{FALSE}, return the data in the object. Caching the file provides a
way to read in very large quantities of textual data without storing two
copies in memory: one as a \link{corpusSource-class} object and the second
as a \link{corpus} class object.  It also provides a way to try different
settings of encoding conversion when creating a corpus from a
\link{corpusSource-class} object, without having to load in all of the
source data again.}

\item{docvarsfrom}{used to specify that docvars should be taken from the
filenames, when the \code{textfile} inputs are filenames and the elements
of the filenames are document variables, separated by a delimiter
(\code{dvsep}).  This allows easy assignment of docvars from filenames such
as \code{1789-Washington.txt}, \code{1793-Washington}, etc. by \code{dvsep}
or from meta-data embedded in the text file header (\code{headers}).}

\item{dvsep}{separator used in filenames to delimit docvar elements if
\code{docvarsfrom="filenames"} is used}

\item{docvarnames}{character vector of variable names for \code{docvars}, if
\code{docvarsfrom} is specified.  If this argument is not used, default
docvar names will be used (\code{docvar1}, \code{docvar2}, ...).}

\item{...}{additional arguments passed through to other functions}
}
\value{
an object of class \link{corpusSource-class} that can be read by
  \link{corpus} to construct a corpus
}
\description{
Read a text corpus from a source file, where the single file will consist of
a set of texts in columns and document variables and document-level meta-data
in additional columns.  For spreadsheet-like files, the first row must be a
header.
}
\details{
The constructor does not store a copy of the texts, but rather reads
  in the texts and associated data, and saves them to a temporary disk file
  whose location is specified in the \link{corpusSource-class} object.  This
  prevents a complete copy of the object from cluttering the global
  environment and consuming additional space.  This does mean however that
  the state of the file containing the source data will not be cross-platform
  and may not be persistent across sessions.  So the recommended usage is to
  load the data into a corpus in the same session in which \code{textfile} is
  called.
}
\examples{
\dontrun{# Twitter json
mytf1 <- textfile("http://www.kenbenoit.net/files/tweets.json")
summary(corpus(mytf1), 5)
# generic json - needs a textField specifier
mytf2 <- textfile("http://www.kenbenoit.net/files/sotu.json",
                  textField = "text")
summary(corpus(mytf2))
# text file
mytf3 <- textfile("https://www.gutenberg.org/cache/epub/2701/pg2701.txt", cache = FALSE)
summary(corpus(mytf3))
# XML data
mytf6 <- textfile("http://www.kenbenoit.net/files/plant_catalog.xml",
                  textField = "COMMON")
summary(corpus(mytf6))
# csv file
write.csv(data.frame(inaugSpeech = texts(inaugCorpus), docvars(inaugCorpus)),
          file = "/tmp/inaugTexts.csv", row.names = FALSE)
mytf7 <- textfile("/tmp/inaugTexts.csv", textField = "inaugSpeech")
summary(corpus(mytf7))
}
}
\author{
Kenneth Benoit and Paul Nulty
}

