% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dfm-methods.R
\name{topfeatures}
\alias{topFeatures}
\alias{topfeatures}
\alias{topfeatures.dfm}
\alias{topfeatures.dgCMatrix}
\title{list the most frequent features}
\usage{
topfeatures(x, ...)

\method{topfeatures}{dfm}(x, n = 10, decreasing = TRUE, ci = 0.95, ...)

\method{topfeatures}{dgCMatrix}(x, n = 10, decreasing = TRUE, ...)
}
\arguments{
\item{x}{the object whose features will be returned}

\item{...}{additional arguments passed to other methods}

\item{n}{how many top features should be returned}

\item{decreasing}{If TRUE, return the \code{n} most frequent features, if
FALSE, return the \code{n} least frequent features}

\item{ci}{confidence interval from 0-1.0 for use if dfm is resampled}
}
\value{
A named numeric vector of feature counts, where the names are the feature labels.
}
\description{
List the most frequently occuring features in a \link{dfm}
}
\examples{
topfeatures(dfm(subset(inaugCorpus, Year>1980), verbose=FALSE))
topfeatures(dfm(subset(inaugCorpus, Year>1980), ignoredFeatures=stopwords("english"),
            verbose=FALSE))
# least frequent features
topfeatures(dfm(subset(inaugCorpus, Year>1980), verbose=FALSE), decreasing=FALSE)
}

