% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dictionaries.R
\name{dictionary}
\alias{dictionary}
\title{create a dictionary}
\usage{
dictionary(x = NULL, file = NULL, format = NULL, toLower = TRUE,
  encoding = "")
}
\arguments{
\item{x}{a list of character vector dictionary entries, including regular 
expressions (see examples)}

\item{file}{file identifier for a foreign dictionary}

\item{format}{character identifier for the format of the foreign dictionary. 
Available options are: \describe{ \item{\code{"wordstat"}}{format used by
Provalis Research's Wordstat software} \item{\code{"LIWC"}}{format used by
the Linguistic Inquiry and Word Count software} }}

\item{toLower}{if \code{TRUE}, convert all dictionary values to lowercase}

\item{encoding}{additional optional encoding value for reading in imported dictionaries. 
This uses the \link{iconv} labels for encoding.  See the "Encoding" section
of the help for \link{file}.}
}
\value{
A dictionary class object, essentially a specially classed named list
  of characters.
}
\description{
Create a quanteda dictionary, either from a list or by importing from a 
foreign format.  Currently supported input file formats are the Wordstat and
LIWC
formats.
}
\examples{
mycorpus <- subset(inaugCorpus, Year>1900)
mydict <- dictionary(list(christmas = c("Christmas", "Santa", "holiday"),
                          opposition = c("Opposition", "reject", "notincorpus"),
                          taxing = "taxing",
                          taxation = "taxation",
                          taxregex = "tax*",
                          country = "united states"))
head(dfm(mycorpus, dictionary=mydict))

\dontrun{
# import the Laver-Garry dictionary from http://bit.ly/1FH2nvf
lgdict <- dictionary(file = "http://www.kenbenoit.net/courses/essex2014qta/LaverGarry.cat",
                     format = "wordstat")
head(dfm(inaugTexts, dictionary=lgdict))

# import a LIWC formatted dictionary from http://www.moralfoundations.org
mfdict <- dictionary(file = "http://ow.ly/VMRkL", format = "LIWC")
head(dfm(inaugTexts, dictionary = mfdict))}
}
\references{
Wordstat dictionaries page, from Provalis Research 
\url{http://provalisresearch.com/products/content-analysis-software/wordstat-dictionary/}.

Pennebaker, J.W., Chung, C.K., Ireland, M., Gonzales, A., & Booth, R.J. 
(2007). The development and psychometric properties of LIWC2007. [Software 
manual]. Austin, TX (\url{www.liwc.net}).
}
\seealso{
\link{dfm}
}

