% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dfm-methods.R
\name{featnames}
\alias{featnames}
\title{get the feature labels from a dfm}
\usage{
featnames(x)
}
\arguments{
\item{x}{the dfm whose features will be extracted}
}
\value{
character vector of the features
}
\description{
Get the features from a document-feature matrix, which are stored as the
column names of the \link{dfm} object.
}
\examples{
inaugDfm <- dfm(data_corpus_inaugural, verbose = FALSE)

# first 50 features (in original text order)
head(featnames(inaugDfm), 50)

# first 50 features alphabetically
head(sort(featnames(inaugDfm)), 50)

# contrast with descending total frequency order from topfeatures()
names(topfeatures(inaugDfm, 50))
}
