% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert.R
\name{convert}
\alias{convert}
\title{convert a dfm to a non-quanteda format}
\usage{
convert(x, to = c("lda", "tm", "stm", "austin", "topicmodels", "lsa",
  "matrix", "data.frame"), docvars = NULL, ...)
}
\arguments{
\item{x}{dfm to be converted}

\item{to}{target conversion format, consisting of the name of the package 
into whose document-term matrix representation the dfm will be converted: 
\describe{ \item{\code{"lda"}}{a list with components "documents" and 
"vocab" as needed by the function \link[lda]{lda.collapsed.gibbs.sampler} from the 
\pkg{lda} package} \item{\code{"tm"}}{a \link[tm]{DocumentTermMatrix} from 
the \pkg{tm} package} \item{\code{"stm"}}{the  format for the \pkg{stm} 
package} \item{\code{"austin"}}{the \code{wfm} format from the 
\strong{austin} package} \item{\code{"topicmodels"}}{the "dtm" format as 
used by the \pkg{topicmodels} package} 
\item{\code{"lsa"}}{the "textmatrix" format as 
used by the \pkg{lsa} package} }}

\item{docvars}{optional data.frame of document variables used as the 
\code{meta} information in conversion to the STM package format.  This aids
in selecting the document variables only corresponding to the documents 
with non-zero counts.}

\item{...}{unused}
}
\value{
A converted object determined by the value of \code{to} (see above). 
  See conversion target package documentation for more detailed descriptions 
  of the return formats.
}
\description{
Convert a quanteda \link{dfm} object to a format useable by other text 
analysis packages.  The general function \code{convert} provides easy 
conversion from a dfm to the document-term representations used in all other 
text analysis packages for which conversions are defined.    See also 
\link{convert-wrappers} for convenience functions for specific package converters.
}
\note{
There also exist a variety of converter shortcut commands, designed to 
mimic the idioms of the packages into whose format they convert.  
See \link{convert-wrappers} for details.
}
\examples{
mycorpus <- corpus_subset(data_corpus_inaugural, Year > 1970)
quantdfm <- dfm(mycorpus, verbose = FALSE)

# austin's wfm format
identical(dim(quantdfm), dim(convert(quantdfm, to = "austin")))

# stm package format
stmdfm <- convert(quantdfm, to = "stm")
str(stmdfm)
# illustrate what happens with zero-length documents
quantdfm2 <- dfm(c(punctOnly = "!!!", mycorpus[-1]), verbose = FALSE)
rowSums(quantdfm2)
stmdfm2 <- convert(quantdfm2, to = "stm", docvars = docvars(mycorpus))
str(stmdfm2)
 
\dontrun{
#' # tm's DocumentTermMatrix format
tmdfm <- convert(quantdfm, to = "tm")
str(tmdfm)

# topicmodels package format
str(convert(quantdfm, to = "topicmodels"))

# lda package format
ldadfm <- convert(quantdfm, to = "lda")
str(ldadfm)
}
}
