% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/textmodel_NB.R
\name{textmodel_NB}
\alias{textmodel_NB}
\title{Naive Bayes classifier for texts}
\usage{
textmodel_NB(x, y, smooth = 1, prior = c("uniform", "docfreq", "termfreq"),
  distribution = c("multinomial", "Bernoulli"), ...)
}
\arguments{
\item{x}{the \link{dfm} on which the model will be fit.  Does not need to contain 
only the training documents.}

\item{y}{vector of training labels associated with each document identified 
in \code{train}.  (These will be converted to factors if not already 
factors.)}

\item{smooth}{smoothing parameter for feature counts by class}

\item{prior}{prior distribution on texts; see Details}

\item{distribution}{count model for text features, can be \code{multinomial} 
or \code{Bernoulli}.  To fit a "binary multinomial" model, first convert the 
dfm to a binary matrix using \code{\link{tf}(x, "boolean")}.}

\item{...}{more arguments passed through}
}
\value{
A list of return values, consisting of:

\item{call}{original function call}

\item{PwGc}{probability of the word given the class (empirical 
  likelihood)}

\item{Pc}{class prior probability}

\item{PcGw}{posterior class probability given the word}

\item{Pw}{baseline probability of the word}

\item{data}{list consisting of \code{x} training class, and \code{y} 
  test class}

\item{distribution}{the distribution argument}

\item{prior}{argument passed as a prior}

\item{smooth}{smoothing parameter}
}
\description{
Fit a multinomial or Bernoulli Naive Bayes model, given a dfm and some
training labels.
}
\section{Predict Methods}{
 A \code{predict} method is also available for a 
  fitted Naive Bayes object, see \code{\link{predict.textmodel_NB_fitted}}.
}

\examples{
## Example from 13.1 of _An Introduction to Information Retrieval_
txt <- c(d1 = "Chinese Beijing Chinese",
         d2 = "Chinese Chinese Shanghai",
         d3 = "Chinese Macao",
         d4 = "Tokyo Japan Chinese",
         d5 = "Chinese Chinese Chinese Tokyo Japan")
trainingset <- dfm(txt, tolower = FALSE)
trainingclass <- factor(c("Y", "Y", "Y", "N", NA), ordered = TRUE)
 
## replicate IIR p261 prediction for test set (document 5)
(nb.p261 <- textmodel_NB(trainingset, trainingclass, prior = "docfreq"))
predict(nb.p261, newdata = trainingset[5, ])

# contrast with other priors
predict(textmodel_NB(trainingset, trainingclass, prior = "uniform"))
predict(textmodel_NB(trainingset, trainingclass, prior = "termfreq"))

## replicate IIR p264 Bernoulli Naive Bayes
(nb.p261.bern <- textmodel_NB(trainingset, trainingclass, distribution = "Bernoulli", 
                              prior = "docfreq"))
predict(nb.p261.bern, newdata = trainingset[5, ])
}
\references{
Manning, C. D., Raghavan, P., & Schütze, H. (2008). Introduction
  to Information Retrieval. Cambridge University Press.
  \url{https://nlp.stanford.edu/IR-book/pdf/irbookonlinereading.pdf}
  
  Jurafsky, Daniel and James H. Martin. (2016) \emph{Speech and Language Processing.}  Draft of November 7, 2016.
  \url{https://web.stanford.edu/~jurafsky/slp3/6.pdf}
}
\author{
Kenneth Benoit
}
