% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/docvars.R
\name{docvars}
\alias{docvars}
\alias{docvars<-}
\title{Get or set document-level variables}
\usage{
docvars(x, field = NULL)

docvars(x, field = NULL) <- value
}
\arguments{
\item{x}{\link{corpus}, \link{tokens}, or \link{dfm} object whose
document-level variables will be read or set}

\item{field}{string containing the document-level variable name}

\item{value}{the new values of the document-level variable}
}
\value{
\code{docvars} returns a data.frame of the document-level variables,
dropping the second dimension to form a vector if a single docvar is
returned.

\verb{docvars<-} assigns \code{value} to the named \code{field}
}
\description{
Get or set variables associated with a document in a \link{corpus},
\link{tokens} or \link{dfm} object.
}
\note{
Reassigning document variables for a \link{tokens} or \link{dfm} object
is allowed, but discouraged.  A better, more reproducible workflow is to
create your docvars as desired in the \link{corpus}, and let these continue
to be attached "downstream" after tokenization and forming a document-feature
matrix.  Recognizing that in some cases, you may need to modify or add
document variables to downstream objects, the assignment operator is defined
for \link{tokens} or \link{dfm} objects as well.  Use with caution.
}
\section{Accessing or assigning docvars using the \code{$} operator}{

As of \pkg{quanteda} v2, it is possible to access and assign a docvar using
the \code{$} operator.  See \link{docvars-internal} for details.
}

\examples{
# retrieving docvars from a corpus
head(docvars(data_corpus_inaugural))
tail(docvars(data_corpus_inaugural, "President"), 10)
head(data_corpus_inaugural$President)

# assigning document variables to a corpus
corp <- data_corpus_inaugural
docvars(corp, "President") <- paste("prez", 1:ndoc(corp), sep = "")
head(docvars(corp))
corp$fullname <- paste(data_corpus_inaugural$FirstName,
                       data_corpus_inaugural$President)
tail(corp$fullname)

}
\keyword{corpus}
