% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dfm.R
\name{dfm}
\alias{dfm}
\title{Create a document-feature matrix}
\usage{
dfm(
  x,
  tolower = TRUE,
  remove_padding = FALSE,
  verbose = quanteda_options("verbose"),
  ...
)
}
\arguments{
\item{x}{a \link{tokens} or \link{dfm} object.}

\item{tolower}{convert all features to lowercase.}

\item{remove_padding}{logical; if \code{TRUE}, remove the "pads" left as empty tokens after
calling \code{\link[=tokens]{tokens()}} or \code{\link[=tokens_remove]{tokens_remove()}} with \code{padding = TRUE}.}

\item{verbose}{display messages if \code{TRUE}.}

\item{...}{not used.}
}
\value{
a \linkS4class{dfm} object
}
\description{
Construct a sparse document-feature matrix from a \link{tokens} or \link{dfm} object.
}
\section{Changes in version 3}{

In \pkg{quanteda} v4, many convenience functions formerly available in
\code{dfm()} were removed.
}

\examples{
## for a corpus
toks <- data_corpus_inaugural |>
  corpus_subset(Year > 1980) |>
  tokens()
dfm(toks)

# removal options
toks <- tokens(c("a b c", "A B C D")) |>
    tokens_remove("b", padding = TRUE)
toks
dfm(toks)
dfm(toks) |>
 dfm_remove(pattern = "") # remove "pads"

# preserving case
dfm(toks, tolower = FALSE)
}
\seealso{
\code{\link[=as.dfm]{as.dfm()}}, \code{\link[=dfm_select]{dfm_select()}}, \linkS4class{dfm}
}
\keyword{dfm}
