% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/Class-ClippedFT.R
\name{ClippedFT-constructor}
\alias{ClippedFT-constructor}
\alias{clippedFT}
\title{Create an instance of the \code{\link{ClippedFT}} class.}
\usage{
clippedFT(Y, frequencies = 2 * pi/lenTS(Y) * 0:(lenTS(Y) - 1), levels = 0.5,
  isRankBased = TRUE, B = 0, l = 0, type.boot = c("none", "mbb"))
}
\arguments{
\item{Y}{A \code{matrix} of real numbers containing the time series from
which to determine the quantile periodogram as columns, or a
           \code{ts} object or a \code{zoo} object.}

\item{frequencies}{A vector containing frequencies at which to determine the
quantile periodogram.}

\item{levels}{A vector of length \code{K} containing the levels at which the
\code{\link{ClippedFT}} frequency representation is to be
determined.}

\item{isRankBased}{If true the time series is first transformed to pseudo
data [cf. \code{\link{FreqRep}}].}

\item{B}{number of bootstrap replications}

\item{l}{(expected) length of blocks}

\item{type.boot}{A flag to choose a method for the block bootstrap; currently
                 two options are implemented: \code{"none"} and \code{"mbb"}
                 which means to do a moving blocks  bootstrap with \code{B}
                 and \code{l} as specified.}
}
\value{
Returns an instance of \code{ClippedFT}.
}
\description{
The parameter \code{type.boot} can be set to choose a block bootstrapping
procedure. If \code{"none"} is chosen, a moving blocks bootstrap with
\code{l=lenTS(Y)} and \code{N=lenTS(Y)} would be done. Note that in that
case one would also chose \code{B=0} which means that \code{getPositions}
would never be called. If \code{B>0} then each bootstrap replication would
be the undisturbed time series.
}
\seealso{
For an example see \code{\link{FreqRep}}.
}
\keyword{Constructors}

