% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Class-SmoothedPG.R
\docType{methods}
\name{getCoherency-SmoothedPG}
\alias{getCoherency,SmoothedPG-method}
\alias{getCoherency-SmoothedPG}
\title{Compute quantile coherency from a smoothed quantile periodogram.}
\usage{
\S4method{getCoherency}{SmoothedPG}(object, frequencies = 2 * pi *
  (0:(lenTS(object@qPG@freqRep@Y) - 1))/lenTS(object@qPG@freqRep@Y),
  levels.1 = getLevels(object, 1), levels.2 = getLevels(object, 2),
  d1 = 1:(dim(object@values)[2]), d2 = 1:(dim(object@values)[4]))
}
\arguments{
\item{object}{\code{SmoothedPG} of which to get the values}

\item{frequencies}{a vector of frequencies for which to get the values}

\item{levels.1}{the first vector of levels for which to get the values}

\item{levels.2}{the second vector of levels for which to get the values}

\item{d1}{optional parameter that determine for which j1 to return the
data; may be a vector of elements 1, ..., D}

\item{d2}{same as d1, but for j2}
}
\value{
Returns data from the array \code{values} that's a slot of
         \code{object}.
}
\description{
Returns quantile coherency defined as
\deqn{\frac{G^{j_1, j_2}(\omega; \tau_1, \tau_2)}{(G^{j_1, j_1}(\omega; \tau_1, \tau_1) G^{j_2, j_2}(\omega; \tau_2, \tau_2))^{1/2}}}
where \eqn{G^{j_1, j_2}(\omega; \tau_1, \tau_2)} is the smoothed quantile
periodogram.
}
\details{
For the mechanism of selecting frequencies, dimensions and/or levels see,
for example, \code{\link{getValues-SmoothedPG}}.
}
\seealso{
An example on how to use this function is analogously to the example given in
\code{\link{getValues-QuantilePG}}.
}
\keyword{Access-functions}

