% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Class-QuantilePG.R
\docType{methods}
\name{getValues-QuantilePG}
\alias{getValues,QuantilePG-method}
\alias{getValues-QuantilePG}
\title{Get values from a quantile periodogram.}
\usage{
\S4method{getValues}{QuantilePG}(object, frequencies = 2 * pi *
  (0:(lenTS(object@freqRep@Y) - 1))/lenTS(object@freqRep@Y),
  levels.1 = getLevels(object, 1), levels.2 = getLevels(object, 2),
  d1 = 1:(dim(object@freqRep@Y)[2]), d2 = 1:(dim(object@freqRep@Y)[2]))
}
\arguments{
\item{object}{\code{QuantilePG} of which to get the values}

\item{frequencies}{a vector of frequencies for which to get the values}

\item{levels.1}{the first vector of levels for which to get the values}

\item{levels.2}{the second vector of levels for which to get the values}

\item{d1}{optional parameter that determine for which j1 to return the
data; may be a vector of elements 1, ..., D}

\item{d2}{same as d1, but for j2}
}
\value{
Returns data from the array \code{values} that's a slot of
         \code{object}.
}
\description{
For vectors \code{frequencies}, \code{levels.1} and \code{levels.2} the
values from an \code{object} of type \code{QuantilePG} are returned.
}
\details{
Fetching of the periodogram values basically happens by passing
\code{frequencies} and the union of \code{levels.1} and \code{levels.2} to
\code{\link{getValues}}. Therefore,
the parameters \code{frequencies}, \code{levels.1} and \code{levels.1} are
expected to be vectors of reals; an error is thrown otherwise. If any of the
\code{frequencies}, \code{levels.1} and \code{levels.2} requested is not
available from \code{object} a warning is issued. Note that the frequencies
are transformed to \eqn{[0,\pi]}{[0,pi]} using \code{\link{frequenciesValidator}}
when checking if they are available in \code{object}.

The returned array of \code{values} is of dimension \code{[J,K1,K2,B+1]},
where \code{J=length(frequencies)}, \code{K1=length(levels.1)},
\code{K2=length(levels.2))}, and \code{B} denotes the
value stored in slot \code{B} of \code{freqRep} that's a slot of \code{object}.
At position \code{(j,k1,k2,b)}
the returned value is the one corresponding to \code{frequencies[j]},
\code{levels.1[k1]} and \code{levels.2[k2]} that are closest to the
\code{frequencies}, \code{levels.1} and \code{levels.2}
available in \code{object}; \code{\link{closest.pos}} is used to determine
what closest to means.
}
\examples{
Y        <- rnorm(32)
freq     <- 2*pi*c(0:31)/32
levels   <- c(0.25,0.5,0.75)
qPG      <- quantilePG(Y, levels.1=levels)
V.all    <- getValues(qPG)
V.coarse <- getValues(qPG, frequencies = 2*pi*c(0:15)/16)
V.fine   <- getValues(qPG, frequencies = 2*pi*c(0:63)/64)
V.part   <- getValues(qPG, frequencies = 2*pi*c(0:16)/32,
                           levels.1 = c(0.25), levels.2 = c(0.5,0.75))
}
\keyword{Access-functions}

