% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Class-KernelWeight.R
\name{getWnj-KernelWeight}
\alias{getWnj-KernelWeight}
\alias{getWnj,KernelWeight-method}
\title{Get attribute \code{Wnj} from a \code{QSpecQuantity}.}
\usage{
\S4method{getWnj}{KernelWeight}(object, j)
}
\arguments{
\item{object}{\code{KernelWeight} from which to get the \code{Wnj}.}

\item{j}{an integer or vector of indices specifying which \code{Wnj[j]}
to return.}
}
\value{
Returns levels attribute, as a vector of real numbers.
}
\description{
If the optional parameter \code{j} is supplied, then only the \code{j}th
element(s) of the vector will be returned, the entire vector otherwise.
}
\examples{
wgt <- kernelWeight(W=W1, N=2^3, bw=0.7)
getWnj(wgt)
getWnj(wgt, 2)
getWnj(wgt, c(2,7))
}
\keyword{Access-functions}
